#!/usr/bin/perl

# Unit testing for PPI, generated by Test::Inline

use strict;
use File::Spec::Functions ':ALL';
BEGIN {
	$|  = 1;
	$^W = 1;
	$PPI::XS_DISABLE = 1;
	$PPI::XS_DISABLE = 1; # Prevent warning
}
use PPI;

# Execute the tests
use Test::More tests => 9;

# =begin testing literal 9
{
my @pairs = (
	"F",          'F',
	"Foo::Bar",   'Foo::Bar',
	"Foo'Bar",    'Foo::Bar',
);
while ( @pairs ) {
	my $from  = shift @pairs;
	my $to    = shift @pairs;
	my $doc   = PPI::Document->new( \"$from;" );
	isa_ok( $doc, 'PPI::Document' );
	my $word = $doc->find_first('Token::Word');
	isa_ok( $word, 'PPI::Token::Word' );
	is( $word->literal, $to, "The source $from becomes $to ok" );
}
}


1;
