#============================================================= -*-perl-*-
#
# t/foriter.t
#
# Template script testing iterators created implicitly via the FOREACH
# directive an explictly using trailing parenthesised parameters.
#
# Written by Andy Wardley <abw@cre.canon.co.uk>
#
# Copyright (C) 1998-1999 Canon Research Centre Europe Ltd.
# All Rights Reserved.
#
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
# $Id: foriter.t,v 1.11 2000/03/20 08:01:36 abw Exp $
#
#========================================================================

use strict;
use lib qw( ../lib );
use Template qw( :status );
use Template::Test;
$^W = 1;

$Template::Test::DEBUG = 0;

my ($a, $b, $c, $d) = qw( alpha bravo charlie delta );
my @days = qw( Monday Tuesday Wednesday Thursday Friday Saturday Sunday );
my @months = qw( jan feb mar apr may jun jul aug sep oct nov dec );
my $day = -1;
my $params = { 
    'a'      => $a,
    'b'      => $b,
    'c'      => $c,
    'C'      => uc $c,
    'd'      => $d,
    'days'   => \@days,
    'months' => \&months,
    'format' => \&format,
    'people' => [ 
	  { id => 'abw', code => 'abw', name => 'Andy Wardley' },
	  { id => 'aaz', code => 'zaz', name => 'Azbaz Azbaz Zazbazzer' },
	  { id => 'bcd', code => 'dec', name => 'Binary Coded Decimal' },
	  { id => 'efg', code => 'zzz', name => 'Extra Fine Grass' },
    ],
};

test_expect(\*DATA, { INTERPOLATE => 1, POST_CHOMP => 1, DEBUG => 1 }, 
	    $params);
 

sub months {
    return \@months;
}

sub format {
    my $format = shift;
    $format = '%s' unless defined $format;
    return sub {
	sprintf($format, shift);
    }
}

#------------------------------------------------------------------------
# test input
#------------------------------------------------------------------------

__DATA__
[% FOREACH item = [ a b c d ] %]
$item
[% END %]
-- expect --
alpha
bravo
charlie
delta

-- test --
[% FOREACH item = [ d C a c b ] order => 'sorted' %]
$item
[% END %]
-- expect --
alpha
bravo
CHARLIE
charlie
delta

-- test --
[% FOREACH item = [ d a c b ] order => 'reverse' %]
$item
[% END %]
-- expect --
delta
charlie
bravo
alpha

-- test --
[% CATCH undef %]
ERROR: [% e.info +%]
[% END %]
[% FOREACH item = [ a b c ] order => 'sideways' %]
$item
[% END %]
[% FOREACH item = [ a b c ] order => inverted %]
$item
[% END %]
-- expect --
ERROR: invalid iterator order: sideways
ERROR: inverted is undefined
alpha
bravo
charlie

-- test --
[% userlist = [ b c d a C 'Andy' 'tom' 'dick' 'harry' ] (order => 'sorted') %]
[% FOREACH u = userlist %]
$u
[% END %]
-- expect --
alpha
Andy
bravo
charlie
CHARLIE
delta
dick
harry
tom

-- test --
[% ulist = [ b c d a 'Andy' ]( order  => 'sorted', 
			       action => format('[- %-7s -]') ) %]
[% FOREACH item = ulist %]
$item
[% END %]
-- expect --
[- alpha   -]
[- Andy    -]
[- bravo   -]
[- charlie -]
[- delta   -]

-- test --
[% FOREACH item = [ a b c d ] %]
[% "List of $loop.size items:\n" IF loop.first %]
  #[% loop.number %]/[% loop.size %]: [% item +%]
[% "That's all folks\n" IF loop.last %]
[% END %]
-- expect --
List of 4 items:
  #1/4: alpha
  #2/4: bravo
  #3/4: charlie
  #4/4: delta
That's all folks

-- test --
[% iterator = [ d b c a ]( order => 'sorted' ) %]
[% FOREACH item = iterator %]
[% "List of $iterator.size items:\n----------------\n" IF iterator.first %]
 * [% item +%]
[% "----------------\n" IF iterator.last  %]
[% END %]
-- expect --
List of 4 items:
----------------
 * alpha
 * bravo
 * charlie
 * delta
----------------

-- test --
[% list = [ a b c d ] %]
[% i = 1 %]
[% FOREACH item = list %]
 #[% i %]/[% list.size %]: [% item +%]
[% i = inc(i) %]
[% END %]
-- expect --
 #1/4: alpha
 #2/4: bravo
 #3/4: charlie
 #4/4: delta


-- test --
[% FOREACH a = ['foo', 'bar', 'baz'] %]
* [% loop.index %] [% a +%]
[% FOREACH b = ['wiz', 'woz', 'waz'] %]
  - [% loop.index %] [% b +%]
[% END %]
[% END %]

-- expect --
* 0 foo
  - 0 wiz
  - 1 woz
  - 2 waz
* 1 bar
  - 0 wiz
  - 1 woz
  - 2 waz
* 2 baz
  - 0 wiz
  - 1 woz
  - 2 waz


-- test --
[% id    = 12345
   name  = 'Original'
   user1 = { id => 'tom', name => 'Thomas'   }
   user2 = { id => 'reg', name => 'Reginald' }
%]
[% FOREACH [ user1 ] %]
  id: [% id +%]
  name: [% name +%]
[% FOREACH [ user2 ] %]
  - id: [% id +%]
  - name: [% name +%]
[% END %]
[% END %]
id: [% id +%]
name: [% name +%]

-- expect --
  id: tom
  name: Thomas
  - id: reg
  - name: Reginald
id: 12345
name: Original

-- test --
[% "$p.id($p.code): $p.name\n"
       FOREACH p = [ people.1 people.2 ] order='sorted' field='id' %]

-- expect --
aaz(zaz): Azbaz Azbaz Zazbazzer
bcd(dec): Binary Coded Decimal

-- test --
[% "$p.id($p.code): $p.name\n"
       FOREACH p = people order='sorted' field='code' %]

-- expect --
abw(abw): Andy Wardley
bcd(dec): Binary Coded Decimal
aaz(zaz): Azbaz Azbaz Zazbazzer
efg(zzz): Extra Fine Grass

-- test --
[% "$p.id($p.code): $p.name\n"
       FOREACH p = people { order='reverse' field='code' } %]

-- expect --
efg(zzz): Extra Fine Grass
aaz(zaz): Azbaz Azbaz Zazbazzer
bcd(dec): Binary Coded Decimal
abw(abw): Andy Wardley

-- test --
[% "$p.id($p.code): $p.name\n"
       FOREACH p = people, order='sorted', field='code' %]

-- expect --
abw(abw): Andy Wardley
bcd(dec): Binary Coded Decimal
aaz(zaz): Azbaz Azbaz Zazbazzer
efg(zzz): Extra Fine Grass







