package Dist::Zilla::App::Command::wiki;

use P;
use Dist::Zilla::App qw[-command];
use Pod::Markdown;

sub abstract ($self) {
    return 'generate wiki docs';
}

sub opt_spec ( $self, $app ) {
    return;
}

sub validate_args ( $self, $opt, $args ) {

    # NOTE args is just raw array or params, that not described as options

    die 'no args expected' if $args->@*;

    return;
}

sub execute ( $self, $opt, $args ) {
    if ( !-d 'wiki/.hg' ) {
        say q[no wiki repository was found];
    }
    else {
        my $base_url = $self->_get_base_url . q[/];

        P->file->rmtree('wiki/POD/');

        my $toc = [];

        # scan lib/ for .pm files
        P->file->find(
            {   wanted => sub {
                    return if -d;

                    my $path = P->file->path($_);

                    if ( $path->suffix eq 'pm' ) {
                        my $parser = Pod::Markdown->new(
                            perldoc_url_prefix       => $base_url,
                            perldoc_fragment_format  => 'pod_simple_html',    # CodeRef ( $self, $text )
                            markdown_fragment_format => 'pod_simple_html',    # CodeRef ( $self, $text )
                            include_meta_tags        => 0,
                        );

                        my $markdown;

                        $parser->output_string( \$markdown );

                        # generate markdown document
                        $parser->parse_string_document( P->file->read_bin($path)->$* );

                        $markdown =~ s/\n+\z//smg;

                        if ($markdown) {

                            # add TOC link
                            $markdown = qq[# [TABLE OF CONTENTS](${base_url}POD)\n\n] . $markdown;

                            # write markdown to the file
                            my $out_path = $path->dirname =~ s[\Alib/][]smr;

                            P->file->mkpath( 'wiki/POD/' . $out_path );

                            push $toc, $out_path . $path->filename_base;

                            P->file->write_text( 'wiki/POD/' . $out_path . $path->filename_base . q[.md], { crlf => 0 }, \$markdown );
                        }
                    }
                },
                no_chdir => 1,
            },
            q[lib/]
        );

        # generate TOC
        my $toc_md = q[];

        for my $link ( $toc->@* ) {
            my $package_name = $link =~ s[/][::]smgr;

            $toc_md .= qq[## [${package_name}](${base_url}POD/${link})\n\n];
        }

        P->file->write_text( 'wiki/POD.md', { crlf => 0 }, \$toc_md );
    }

    return;
}

sub _get_base_url {
    if ( -f 'wiki/.hg/hgrc' ) {
        my $hgrc = P->file->read_text('wiki/.hg/hgrc');

        if ( $hgrc->$* =~ /default\s*=\s*(.+?)$/sm ) {
            my $repo_url = $1;

            my $uri = P->uri($repo_url);

            return $uri->path;
        }
    }

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 7                    │ NamingConventions::ProhibitAmbiguousNames - Ambiguously named subroutine "abstract"                            │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Dist::Zilla::App::Command::wiki" does not start with a upper case │
## │      │                      │ letter                                                                                                         │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
