package Pcore::Handle::xmpp;

use Pcore -class;
use AnyEvent::XMPP::Client;

# use AnyEvent::XMPP::Ext::Disco;
# use AnyEvent::XMPP::Ext::HTML;

with qw[Pcore::Handle::Wrapper];

sub _connect ($self) {
    my $uri = $self->uri;

    my $h = AnyEvent::XMPP::Client->new;

    my $host = exists $uri->query_params->{gtalk} || $uri->host->name eq 'gmail.com' ? 'talk.google.com' : $uri->host->name;

    $h->add_account( $uri->username . '@' . $uri->host, $uri->password, $host, $uri->port || 5222, undef ) or die;

    # $h->add_extension( my $disco = AnyEvent::XMPP::Ext::Disco->new );
    # $h->add_extension( AnyEvent::XMPP::Ext::HTML->new( disco => $disco ) );

    $h->reg_cb(
        session_ready => sub ( $h, $account ) {
            while ( my $msg = shift $self->{_queue}->@* ) {
                $h->send_message( $msg->@*, undef, 'chat' );
            }

            return;
        },
        disconnect => sub ( $cl, $acc, $h, $p, $reas ) {
            return;
        },
        error => sub ( $cl, $acc, $err ) {
            die $err->string;
        },

        #     message => sub ( $cl, $acc, $msg ) {
        #         say 'x' x 10;
        #         say dump { $msg->subjects };
        #         say dump { $msg->bodies };
        #
        #         print "message from: " . ( $msg->from // q[] ) . ": " . ( $msg->any_body // q[] ) . "\n";
        #     }
    );

    $h->start;

    return $h;
}

sub _disconnect ($self) {
    $self->h->disconnect;

    return;
}

sub sendmsg ( $self, $to, $msg ) {
    if ( !$self->h->get_connected_accounts ) {
        push $self->{_queue}->@*, [ $msg, $to ];

        return;
    }

    $self->h->send_message( $msg, $to, undef, 'chat' );

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 |                      | Subroutines::ProhibitUnusedPrivateSubroutines                                                                  |
## |      | 11                   | * Private subroutine/method '_connect' declared but not used                                                   |
## |      | 52                   | * Private subroutine/method '_disconnect' declared but not used                                                |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Handle::xmpp

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
