package Pcore::Core::Event::Listener::Pipe::xmpp;

use Pcore -class, -ansi;
use Pcore::Util::Text qw[remove_ansi];

with qw[Pcore::Core::Event::Listener::Pipe];

has header => ( is => 'ro', isa => Str, default => '[<: $date.strftime("%Y-%m-%d %H:%M:%S.%4N") :>][<: $channel :>][<: $level :>]' );

has tmpl => ( is => 'ro', isa => InstanceOf ['Pcore::Util::Template'], init_arg => undef );
has h    => ( is => 'ro', isa => InstanceOf ['Pcore::Handle::xmpp'],   init_arg => undef );

has _init => ( is => 'ro', isa => Bool, init_arg => undef );

sub sendlog ( $self, $ev, $data ) {

    # init
    if ( !$self->{_init} ) {
        $self->{_init} = 1;

        # init template
        $self->{tmpl} = P->tmpl;

        my $template = qq[$self->{header} <: \$title | raw :>
: if \$body {
<: \$body | raw :>
: }];

        $self->{tmpl}->cache_string_tmpl( message => \$template );

        $self->{h} = P->handle( $self->{uri} );
    }

    # sendlog
    {
        local $data->{date} = P->date->from_epoch( $data->{timestamp} );

        # indent body
        local $data->{body} = $data->{body} =~ s/^/    /smgr if $data->{body};

        my $message = $self->{tmpl}->render( 'message', $data );

        remove_ansi $message->$*;

        $self->{h}->sendmsg( $self->{uri}->query_params->{to}, $message->$* );
    }

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 24                   | ValuesAndExpressions::ProhibitImplicitNewlines - Literal line breaks in a string                               |
## |------+----------------------+----------------------------------------------------------------------------------------------------------------|
## |    2 | 36, 39               | Variables::ProhibitLocalVars - Variable declared as "local"                                                    |
## |------+----------------------+----------------------------------------------------------------------------------------------------------------|
## |    1 | 8                    | ValuesAndExpressions::RequireInterpolationOfMetachars - String *may* require interpolation                     |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Core::Event::Listener::Pipe::xmpp

=head1 SYNOPSIS

    P->listen_events( 'LOG.TEST.*', 'xmpp://username:password@google.com?gtalk=1&to=username@host.com' );

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
