package Pcore::Core::Logger::Pipe::xmpp;

use Pcore -class;

extends qw[Pcore::Core::Logger::Pipe];

has to => ( is => 'ro', isa => Str, required => 1 );

has hid => ( is => 'lazy', isa => Str, init_arg => undef );

around new => sub ( $orig, $self, $args ) {
    $args->{to} = $args->{uri}->query_params->{to};

    return $self->$orig($args);
};

sub _build_id ($self) {
    return 'xmpp://' . $self->uri->username . q[@] . $self->uri->host . q[?to=] . $self->to;
}

sub _build_hid ($self) {
    my $hid = 'xmpp://' . $self->uri->username . q[@] . $self->uri->host;

    H->add(
        $hid => 'xmpp',
        addr => $self->uri->to_string,
    );

    return $hid;
}

sub sendlog ( $self, $header, $data, $tag ) {
    my $hid = $self->hid;

    my $h = H->$hid;

    $h->sendmsg( $self->to, $data );

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Pcore::Core::Logger::Pipe::xmpp" does not start with a upper case │
## │      │                      │ letter                                                                                                         │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Core::Logger::Pipe::xmpp

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
