package Pcore::Whois::Request;

use Pcore -class;
use Pcore::Whois::Data qw[:CONST];
use Pcore::AE::Handle;
use Pcore::Whois::Response;

has id => ( is => 'ro', isa => Str, required => 1 );
has whois => ( is => 'ro', isa => InstanceOf ['Pcore::Whois'], required => 1 );
has retries => ( is => 'ro', isa => PositiveInt, required => 1 );
has server => ( is => 'ro', isa => InstanceOf ['Pcore::Whois::Server'], required => 1 );
has query   => ( is => 'ro', isa => Str,      required => 1 );
has request => ( is => 'ro', isa => ArrayRef, required => 1 );

has is_started => ( is => 'ro', isa => Bool, default => 0, init_arg => undef );

# TODO push is not effective
sub run ($self) {
    return if $self->is_started;

    my $queue_idx;
    my $queue = $self->whois->requests_queue;

    for ( my $i = 0; $i <= $queue->$#*; $i++ ) {
        if ( $queue->[$i] eq $self ) {
            $queue_idx = $i;

            last;
        }
    }

    if ( $self->whois->max_threads && $self->whois->threads >= $self->whois->max_threads ) {
        push $self->whois->requests_queue->@*, $self if !defined $queue_idx;
    }
    elsif ( $self->whois->max_threads_server && $self->server->threads >= $self->whois->max_threads_server ) {
        push $self->whois->requests_queue->@*, $self if !defined $queue_idx;
    }
    else {
        splice $queue->@*, $queue_idx, 1, () if defined $queue_idx;

        $self->{is_started} = 1;

        $self->whois->{threads}++;

        $self->server->{threads}++;

        $self->_start;
    }

    return;
}

# TODO proxy support
sub _start ($self) {

    # TODO proxy support
    # if ( $whois->proxy ) {
    #     $whois->proxy->get_slot(
    #         [ $self->host, 43, 'whois' ],
    #         wait   => 0,
    #         ban_id => $self->host,
    #         sub ($proxy) {
    #             $run->($proxy);
    #
    #             return;
    #         }
    #     );
    # }

    Pcore::AE::Handle->new(
        connect         => [ $self->server->host, 43, 'whois' ],
        connect_timeout => $self->whois->timeout,
        timeout         => $self->whois->timeout,
        persistent      => 0,
        bind_ip => $self->whois->ip_pool ? $self->whois->ip_pool->get( $self->server->host ) : undef,

        # TODO proxy => $proxy,
        proxy_wait   => 1,
        proxy_ban_id => $self->server->host,

        # on_proxy_connect_error => sub {
        #     $self->request( $query, %args, $cb );
        #
        #     return;
        # },
        on_error => sub ( $h, $fatal, $reason ) {
            $self->_finish( $WHOIS_STATUS_NETWORK, $reason, undef );

            return;
        },
        on_connect => sub ( $h, $host, $port, $retry ) {
            $h->push_write( $self->server->get_request_content( $self->query ) );

            # read all data until server close socket
            $h->read_eof(
                sub ( $h, $buf_ref, $total_bytes_readed, $error ) {
                    $self->_finish( $WHOIS_STATUS_OK, 'OK', $buf_ref );

                    return;
                }
            );

            return;
        }
    );

    return;
}

# TODO process proxy ban
# TODO how to effectively select next thread
sub _finish ( $self, $status, $reason, $data_ref ) {
    my $res = Pcore::Whois::Response->new(
        {   query  => $self->query,
            server => $self->server,
            status => $status,
            reason => $reason,
            raw    => $data_ref,
        }
    );

    # if ( !$res->is_success && $res->status == $WHOIS_STATUS_BANNED && $h->{proxy} ) {
    #     $h->{proxy}->ban( $self->host );
    #
    #     # repeat request if has proxy and proxy is banned
    #     $self->request( $query, $args->%*, $cb );
    # }

    if ( !$res->is_success && --$self->{retries} > 0 ) {
        $self->_start;
    }
    elsif ( $res->is_verisign && !defined $self->server->is_verisign ) {

        # repeat request to the verisign server
        $self->server->{is_verisign} = 1;

        $self->_start;
    }
    else {
        $self->whois->{threads}--;

        $self->server->{threads}--;

        delete $self->whois->requests->{ $self->id };

        while ( my $request = shift $self->request->@* ) {
            $request->[1]->( $request->[0], $res );
        }

        for my $next_req ( $self->whois->requests_queue->@* ) {
            $next_req->run;
        }
    }

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    2 │ 24                   │ ControlStructures::ProhibitCStyleForLoops - C-style "for" loop used                                            │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Request

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
