package Pcore::Whois::Data;

use Pcore -const, -export => {    #
    CONST => [qw[$WHOIS_STATUS_OK $WHOIS_STATUS_NO_SERVER $WHOIS_STATUS_NETWORK $WHOIS_STATUS_BANNED $WHOIS_STATUS_NO_CONTENT]],
};

const our $WHOIS_STATUS_OK         => 200;
const our $WHOIS_STATUS_NO_SERVER  => 404;
const our $WHOIS_STATUS_NETWORK    => 500;
const our $WHOIS_STATUS_BANNED     => 501;
const our $WHOIS_STATUS_NO_CONTENT => 502;

const our $NOT_AVAIL_DOMAIN => 'cwxtwtqcuduvo78hr0dbrfxpuhv8gmtm';

our $TLD = {                      #
    'web.za' => 'web-whois.registry.net.za',
    'org.za' => 'org-whois.registry.net.za',
    'net.za' => 'net-whois.registry.net.za',
    'co.za'  => 'whois.registry.net.za',
};

our $TLD_NOT_AVAIL = {
    edu => 1,
    gov => 1,
    mil => 1,
};

our $SERVER = {
    'whois.arin.org'         => { req_format  => 'n + <: QUERY :>' . $CRLF },
    'whois.denic.de'         => { req_format  => '-C UTF-8 -T dn,ace <: QUERY :>' . $CRLF },
    'whois.dk-hostmaster.dk' => { req_format  => '--show-handles <: QUERY :>' . $CRLF },
    'whois.jprs.jp'          => { req_format  => '<: QUERY :>/e' . $CRLF },
    'whois.nic.name'         => { req_format  => 'domain = <: QUERY :>' . $CRLF },
    'whois.nic.org.mt'       => { req_format  => '<: QUERY :>' . $LF },
    'whois.verisign-grs.com' => { is_verisign => 1 },
};

our $VERISIGN_RE = [    #
    qr/To single out one record, look it up with/sm,
    qr/look them up with .+? to receive a full display/sm,
];

our $RATE_LIMIT_RE = [    #
    qr/Your request is being rate limited/sm,
    qr/Too many requests/sm,
    qr/Number of allowed queries exceeded/sm,
    qr/You exceeded the maximum allowable number of whois lookups/sm,
    qr/the WHOIS query quota for (.+?) has been exceeded/sm,
];

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Data

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
