package WWW::CDN;

use Pcore -const, -ansi;

# NOTE https://cdnjs.com/libraries/extjs

our $RESOURCES = P->cfg->load( $ENV->share->get('/data/cdn.json') ) or die q["/data/cdn.json" was not found];

our $LATEST_VERSION = { map { $_ => [ sort keys $RESOURCES->{$_}->%* ]->[-1] } keys $RESOURCES->%* };

sub validate_links ($self) {
    my $report;

    my $cv = AE::cv sub {
        $ENV->share->store( '/data/cdn.json', $RESOURCES, 'Pcore-ExtJS' );

        say dump $report if $report;

        return;
    };

    $cv->begin;

    my $process = sub ($hash_ref) {
        for my $key ( keys $hash_ref->%* ) {
            if ( ref $hash_ref->{$key} eq 'HASH' ) {
                __SUB__->( $hash_ref->{$key} );
            }
            else {
                $hash_ref->{$key} = [ $hash_ref->{$key} ] if ref $hash_ref->{$key} ne 'ARRAY';

                my $link = $hash_ref->{$key};

                $cv->begin;

                P->http->get(
                    $link->[0],
                    on_finish => sub ($res) {
                        say "$res - $link->[0]";

                        if ( !$res ) {
                            push $report->{ $res->status }->@*, $link->[0];
                        }
                        else {
                            my $hash = 'sha384-' . P->digest->sha384_b64( $res->body->$* );

                            if ( !$link->[1] ) {
                                $link->[1] = $hash;
                            }
                            elsif ( $link->[1] ne $hash ) {
                                push $report->{'INVALID HASH'}->@*, $link->[0];
                            }
                        }

                        $cv->end;

                        return;
                    }
                );
            }
        }

        return;
    };

    $process->($RESOURCES);

    $cv->end;

    $cv->recv;

    return;
}

sub generate_extjs_links ($self) {
    my $ver = '6.2.0';

    my $urls = {};

    # $urls->{fontawesome}->{'v4.7.0'}->{'font-awesome.css'} = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css';

    # $urls->{jquery}->{'v3.1.1'}->{'jquery.min.js'}      = 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js';
    # $urls->{jquery}->{'v3.1.1'}->{'jquery.slim.min.js'} = 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.slim.min.js';

    $urls->{extjs}->{"v${ver}"}->{classic}->{'ext-all.js'}       = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/ext-all.js";
    $urls->{extjs}->{"v${ver}"}->{classic}->{'ext-all-debug.js'} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/ext-all-debug.js";

    $urls->{extjs}->{"v${ver}"}->{modern}->{'ext-all.js'}       = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/ext-modern-all.js";
    $urls->{extjs}->{"v${ver}"}->{modern}->{'ext-all-debug.js'} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/ext-modern-all-debug.js";

    $urls->{extjs}->{"v${ver}"}->{classic}->{'ux.js'}       = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/packages/ux/classic/ux.js";
    $urls->{extjs}->{"v${ver}"}->{classic}->{'ux-debug.js'} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/packages/ux/classic/ux-debug.js";

    $urls->{extjs}->{"v${ver}"}->{modern}->{'ux.js'}       = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/packages/ux/modern/ux.js";
    $urls->{extjs}->{"v${ver}"}->{modern}->{'ux-debug.js'} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/packages/ux/modern/ux-debug.js";

    # classic themes
    for my $theme (qw[aria classic crisp crisp-touch gray neptune neptune-touch triton]) {
        for my $debug ( q[], '-debug' ) {
            $urls->{extjs}->{"v${ver}"}->{classic}->{theme}->{$theme}->{"theme-${theme}-all${debug}.css"} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/classic/theme-${theme}/resources/theme-${theme}-all${debug}.css";

            $urls->{extjs}->{"v${ver}"}->{classic}->{theme}->{$theme}->{"theme-${theme}${debug}.js"} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/classic/theme-${theme}/theme-${theme}${debug}.js";
        }
    }

    # modern themes
    for my $theme (qw[cupertino ios material mountainview neptune triton windows]) {
        for my $debug ( q[], '-debug' ) {
            $urls->{extjs}->{"v${ver}"}->{modern}->{theme}->{$theme}->{"theme-${theme}-all${debug}.css"} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/modern/theme-${theme}/resources/theme-${theme}-all${debug}.css";

            $urls->{extjs}->{"v${ver}"}->{modern}->{theme}->{$theme}->{"theme-${theme}${debug}.js"} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/modern/theme-${theme}/theme-${theme}${debug}.js";
        }
    }

    # locale
    for my $locale (qw[af bg ca cs da de el_GR en en_AU en_GB es et fa fi fr fr_CA gr he hr hu id it ja ko lt lv mk nl no_NB no_NN pl pt pt_BR pt_PT ro ru sk sl sr sr_RS sv_SE th tr ukr vn zh_CN zh_TW]) {
        for my $debug ( q[], '-debug' ) {
            $urls->{extjs}->{"v${ver}"}->{classic}->{locale}->{"locale-${locale}${debug}.js"} = "https://cdnjs.cloudflare.com/ajax/libs/extjs/${ver}/classic/locale/locale-${locale}${debug}.js";
        }
    }

    $RESOURCES->@{ keys $urls->%* } = values $urls->%*;

    $ENV->share->store( '/data/cdn.json', $RESOURCES, 'Pcore-ExtJS' );

    return;
}

# GET LINKS
sub fontawesome ( $self, $ver = undef ) {
    $ver //= $LATEST_VERSION->{fontawesome};

    if ( my $link = $RESOURCES->{fontawesome}->{$ver}->{'font-awesome.css'} ) {
        return qq[<link rel="stylesheet" href="$link->[0]" integrity="$link->[1]" crossorigin="anonymous" />];
    }
    else {
        return;
    }
}

sub extjs ( $self, $ver, $framework, $theme, $debug = undef ) {
    $ver //= $LATEST_VERSION->{extjs};

    $debug = $debug ? '-debug' : q[];

    state $cache = {};

    my $id = "extjs/$ver/$framework/$theme/$debug";

    if ( !exists $cache->{$id} ) {
        my $links = [];

        # extjs
        if ( my $link = $RESOURCES->{extjs}->{$ver}->{$framework}->{"ext-all${debug}.js"} ) {
            push $links->@*, qq[<script src="$link->[0]" integrity="$link->[1]" crossorigin="anonymous"></script>];
        }
        else {
            return;
        }

        # extjs ux
        if ( my $link = $RESOURCES->{extjs}->{$ver}->{$framework}->{"ux${debug}.js"} ) {
            push $links->@*, qq[<script src="$link->[0]" integrity="$link->[1]" crossorigin="anonymous"></script>];
        }
        else {
            return;
        }

        # theme .css
        if ( my $link = $RESOURCES->{extjs}->{$ver}->{$framework}->{theme}->{$theme}->{"theme-${theme}-all${debug}.css"} ) {
            push $links->@*, qq[<link rel="stylesheet" href="$link->[0]" integrity="$link->[1]" crossorigin="anonymous" />];
        }
        else {
            return;
        }

        # theme .js
        if ( my $link = $RESOURCES->{extjs}->{$ver}->{$framework}->{theme}->{$theme}->{"theme-${theme}${debug}.js"} ) {
            push $links->@*, qq[<script src="$link->[0]" integrity="$link->[1]" crossorigin="anonymous"></script>];
        }
        else {
            return;
        }

        $cache->{$id} = $links;
    }

    return $cache->{$id};
}

sub extjs_locale ( $self, $ver, $framework, $locale, $debug = undef ) {
    $ver //= $LATEST_VERSION->{extjs};

    $debug = $debug ? '-debug' : q[];

    state $cache = {};

    my $id = "extjs/$ver/$framework/$debug";

    if ( !exists $cache->{$id} ) {
        if ( my $link = $RESOURCES->{extjs}->{$ver}->{$framework}->{locale}->{"locale-${locale}${debug}.js"} ) {
            $cache->{$id} = qq[<script src="$link->[0]" integrity="$link->[1]" crossorigin="anonymous"></script>];
        }
        else {
            return;
        }
    }

    return $cache->{$id};
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

WWW::CDN

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
