Ext.define('Ext.override.data.proxy.Direct', {
    override: 'Ext.data.proxy.Direct',

    compatibility: '6.*',

    batchActions: true,
    pageParam: '',

    reader: {
        type: 'json',
        rootProperty: 'data'
    },

    writer: {
        clientIdProperty: '__client_id__'
    }
});

Ext.define('Ext.override.data.operation.Operation', {
    override: 'Ext.data.operation.Operation',

    compatibility: '6.*',

    getStatus: function () {
        if (this.hasException()) {
            var error = this.getError();

            if (Ext.typeOf(error) == 'object') {
                return error.status;
            } else {

                // TODO get and return XHR status
                return 500;
            }
        } else {
            return this.getResponse().result.status;
        }
    },

    getReason: function () {
        if (this.hasException()) {
            return this.getErrorReason();
        } else {
            return this.getResponse().result.reason;
        }
    },

    getErrorReason: function () {
        var error = this.getError();

        if (Ext.typeOf(error) == 'object') {
            return error.reason;
        } else {
            return error;
        }
    },

    getFieldsValidationError: function () {
        var error = this.getError();

        if (Ext.typeOf(error) == 'object' && Ext.typeOf(error.error) == 'object') {
            return error.error;
        } else {
            return;
        }
    }
});

Ext.define('Ext.override.direct.Event', {
    override: 'Ext.direct.Event',

    compatibility: '6.*',

    getStatus: function () {
        var error = this.message;

        if (error) {
            if (Ext.typeOf(error) == 'object') {
                return error.status;
            } else {

                // TODO get and return XHR status
                return 500;
            }
        } else {
            return this.result.status;
        }
    },

    getReason: function () {
        if (this.message) {
            return this.getErrorReason();
        } else {
            return this.result.reason;
        }
    },

    getErrorReason: function () {
        var error = this.message;

        if (Ext.typeOf(error) == 'object') {
            return error.reason;
        } else {
            return error;
        }
    },

    getFieldsValidationError: function () {
        var error = this.message;

        if (Ext.typeOf(error) == 'object' && Ext.typeOf(error.error) == 'object') {
            return error.error;
        } else {
            return;
        }
    }
});
