package Pcore::Ext::Class::Controller;

use Pcore;

our $EXT_MAP = {    #
    controller => 'Ext.app.ViewController',
};

sub EXT_controller ($ext) {
    return {
        _createFormPanel => $ext->js_func(
            [ 'formPanelClass', 'model', 'formPanelCfg' ], <<'JS'
                this.getViewModel().set('editModel', model);

                var defaultCfg = {
                    editModel: model,
                    viewModel: {
                        parent: this.getView().getViewModel()
                    }
                };

                var formPanel = Ext.create(formPanelClass, Ext.apply(defaultCfg, formPanelCfg));

                return formPanel;
JS
        ),

        _createFormPanelWindow => $ext->js_func(
            [ 'formPanel', 'windowCfg' ], <<'JS'
                var defaultCfg = {
                    // layout
                    layout: 'fit',
                    modal: true,
                    draggable: false,
                    resizable: false,
                    constrain: true,
                    renderTo: Ext.getBody(),
                    autoShow: true,

                    // items
                    items: formPanel,

                    // listeners
                    listeners: {
                        scope: 'this',
                        beforeClose: 'onBeforeClose'
                    },

                    // methods
                    onBeforeClose: function () {
                        formPanel.cancelForm();

                        return false;
                    }
                };

                if (formPanel.title) {
                    defaultCfg.title = formPanel.title;

                    formPanel.title = null;
                }

                var win = Ext.create('Ext.window.Window', Ext.apply(defaultCfg, windowCfg));

                formPanel.on('destroy', function () {
                    win.destroy();
                }, this);

                return win;
JS
        ),
    };
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Ext::Class::Controller

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
