package Pcore::Ext::Lib::AmCharts;

use Pcore -class;
use Pcore::Resources;

sub EXT_panel ($ext) : Extend('Ext.Component') {
    return {
        config => {
            store       => undef,
            chartConfig => undef,
        },

        layout              => 'fit',
        defaultBindProperty => 'store',

        constructor => $ext->js_func(
            ['config'], <<'JS'
                this.callParent(arguments);

                this._loadCharts();
JS
        ),

        afterRender => $ext->js_func(
            <<'JS'
                this.callParent(arguments);

                this._onReady();
JS
        ),

        updateStore => $ext->js_func(
            [ 'newStore', 'oldStore' ], <<'JS'
                var me = this,
                    bindEvents = Ext.apply({
                        scope: me
                    }, me.getStoreListeners());

                if (oldStore && Ext.isObject(oldStore) && oldStore.isStore) {
                    oldStore.un(bindEvents);
                }

                if (newStore) {
                    newStore.on(bindEvents);
                }

                this._onReady();
JS
        ),

        getStoreListeners => $ext->js_func(
            ['store'], <<'JS'
                return {
                    load: this._onReady
                    // prefetch: this.updateInfo,
                    // exception: this.onTotalCountChange
                };
JS
        ),

        _loadCharts => $ext->js_func(
            <<"JS"
                var urls = [],
                    chartConfig = this.getChartConfig(),
                    chartsBaseUrl = '/static/amcharts/$Pcore::Resources::VER->{amcharts}/',
                    mapBaseUrl = '/static/ammap/$Pcore::Resources::VER->{ammap}/';

                if (typeof AmCharts == 'undefined') {
                    urls.push( chartsBaseUrl + 'amcharts.js');

                    if (chartConfig.type == 'map') {
                        urls.push( mapBaseUrl + 'ammap_amcharts_extension.js');
                    }
                    else {
                        urls.push( chartsBaseUrl + chartConfig.type + '.js');
                    }

                    if (chartConfig.theme) urls.push( chartsBaseUrl + 'themes/' + chartConfig.theme + '.js');
                } else {
                    if (chartConfig.type == 'map') {
                        if (typeof AmCharts.AmMap == 'undefined') urls.push( mapBaseUrl + 'ammap_amcharts_extension.js');
                    }
                    else {
                        var map = {
                            serial: 'AmSerialChart',
                            pie: 'AmPieChart',
                            xy: 'AmXYChart',
                            radar: 'AmRadarChart',
                            funnel: 'AmFunnelChart',
                            gauge: 'GaugeAxis',
                            stock: 'AmStockChart'
                        };

                        if (typeof AmCharts[chartConfig.type] == 'undefined') urls.push( chartsBaseUrl + chartConfig.type + '.js');
                    }

                    if (chartConfig.theme && typeof AmCharts.themes[chartConfig.theme] == 'undefined') urls.push( chartsBaseUrl + 'themes/' + chartConfig.theme + '.js');
                }

                if (urls.length) {
                    var me = this;

                    Ext.Loader.loadScripts({
                        url: urls,
                        cache: true,
                        onLoad: function () {
                            AmCharts.AmChart.prototype.brr = function () {};

                            me.chartsLoaded = true;

                            me._onReady();
                        }
                    });
                } else {
                    this.chartsLoaded = true;

                    this._onReady();
                }
JS
        ),

        _onReady => $ext->js_func(
            <<'JS'
                if (!this.chartsLoaded) return;
                if (!this.rendered) return;

                if (!this.chart) {
                    this.chart = AmCharts.makeChart(this.innerElement.dom, this.getChartConfig());

                    this.chart.write(this.innerElement.dom);
                }

                if (this.getStore()) {
                    this.chart.dataProvider = Ext.Array.pluck(this.getStore().data.items, 'data');

                    this.chart.validateData();
                }
JS
        ),
    };
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Ext::Lib::AmCharts

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
