package Pcore::Captcha::Antigate;

use Pcore qw[-class];
use Pcore::Captcha;

has api_key => ( is => 'ro', isa => Str, required => 1 );

has _pool => ( is => 'lazy', isa => HashRef, default => sub { {} }, init_arg => undef );
has _timer => ( is => 'rwp', isa => InstanceOf ['EV::Timer'], predicate => 1, clearer => 1, init_arg => undef );

no Pcore;

our $RESOLVER_TIMEOUT = 3;

sub add {
    my $self = shift;

    my $captcha;

    if ( ref $_[0] eq 'Pcore::Captcha' ) {
        $captcha = shift;

        delete $self->_pool->{ $captcha->id } if $captcha->has_id;

        $captcha->clear;
    }
    else {
        my %args = @_;

        $captcha = Pcore::Captcha->new( \%args );
    }

    my $params = {};

    for my $param (qw[phrase regsense numeric calc min_len max_len is_russian soft_id header_acao]) {
        $params->{$param} = $captcha->$param if defined $captcha->$param;
    }

    $params->{key} = $self->api_key;

    $params->{method} = 'base64';

    $params->{body} = P->data->to_b64( $captcha->captcha->$*, q[] );

    P->ua->post(
        q[http://antigate.com/in.php],
        body      => P->data->to_uri($params),
        headers   => { CONTENT_TYPE => 'application/x-www-form-urlencoded', },
        on_finish => sub ($res) {
            my $id;

            if ( $res->status == 200 ) {
                if ( $res->body->$* =~ /\AOK[|](\d+)\z/sm ) {
                    $id = $1;

                    $captcha->_set_id($id);

                    $self->_pool->{$id} = $captcha;

                    $self->_run_resolver;
                }
                else {
                    $self->_resolved( $captcha, undef, $self->body->$* );
                }
            }
            else {
                $self->_resolved( $captcha, undef, $res->reason );
            }

            return;
        }
    );

    return;
}

sub report_failure {
    my $self    = shift;
    my $captcha = shift;

    return if !$captcha->has_id;

    P->ua->request( 'http://antigate.com/res.php?key=' . $self->api_key . '&action=reportbad&id=' . $captcha->id );

    return;
}

sub get_balance {
    my $self = shift;

    # http://antigate.com/res.php?key=ddcda6f268cfd3445a5afc302689ccd2&action=getbalance

    return;
}

sub get_xml_stats {
    my $self = shift;

    # http://antigate.com/res.php?key=ddcda6f268cfd3445a5afc302689ccd2&action=getstats&date=2015-02-15

    return;
}

sub get_realtime_stats {
    my $self = shift;

    # http://antigate.com/load.php
    # waiting: количество работников ожидающих капчу. Максимально показываемое число - 50.
    # load: процент загрузки работников
    # minbid: минимальная ставка необходимая для прохождения вашей капчи
    # averageRecognitionTime: среднее время (в секундах) за которое в данный момент разгадываются капчи

    return;
}

sub _resolved {
    my $self    = shift;
    my $captcha = shift;
    my $result  = shift;
    my $error   = shift;

    delete $self->_pool->{ $captcha->id } if $captcha->has_id;

    if ($error) {
        $captcha->_set_error($error);
    }
    else {
        $captcha->_set_result($result);
    }

    $captcha->cb->($captcha);

    return;
}

sub _run_resolver {
    my $self = shift;

    return if $self->_has_timer;

    return if !keys $self->_pool->%*;

    $self->_set__timer(
        AnyEvent->timer(
            after => $RESOLVER_TIMEOUT,
            cb    => sub {
                $self->_clear_timer;

                my @ids = keys $self->_pool->%*;

                P->ua->request(
                    'http://antigate.com/res.php?key=' . $self->api_key . '&action=get&ids=' . join( q[,], @ids ),
                    on_finish => sub ($res) {
                        if ( $res->status == 200 ) {
                            my @content = split /[|]/sm, $res->body->$*;

                            for my $id (@ids) {
                                my $content = shift @content;

                                if ( $content ne 'CAPCHA_NOT_READY' ) {
                                    if ( $content =~ /\AERROR_/sm ) {
                                        $self->_resolved( $self->_pool->{$id}, undef, $content );
                                    }
                                    else {
                                        $self->_resolved( $self->_pool->{$id}, $content, undef );
                                    }
                                }
                            }
                        }

                        $self->_run_resolver;

                        return;
                    },
                );

                return;
            },
        )
    );

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 141, 149             │ References::ProhibitDoubleSigils - Double-sigil dereference                                                    │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
