package BlankOnDev;
use strict;
use warnings;

# Import :
use BlankOnDev::DataDev;

# Version :
require BlankOnDev::Version;
our $VERSION = $BlankOnDev::Version::VERSION;

# Subroutine for check Home Dir :
# ------------------------------------------------------------------------
sub check_homedir {
    my $homedir = $ENV{"HOME"};
    if ($homedir =~ m/root/) {
        return 0;
    } else {
        return 1;
    }
}

# Subroutine for check directory BlankOnDev :
# ------------------------------------------------------------------------
sub check_dir_boidev {
    # For Data Developer :
    my $data_dev = BlankOnDev::DataDev::data_dev();
    my $home_dir = $data_dev->{'home_dir'};
    my $dir_dev = $data_dev->{'dir_dev'};
    my $prefix_flcfg = $data_dev->{'prefix_flcfg'};
    my $file_cfg_ext = $data_dev->{'fileCfg_ext'};
    my $dir_pkgs = $data_dev->{'dir_pkg'};

    my $result = 0;
    unless (-d $dir_dev) {
        $result = 0;
    } else {
        my $loc_dirpkg = $dir_dev.$dir_pkgs;
        unless (-d $loc_dirpkg) {
            $result = 0;
        } else {
            $result = 1;
        }
    }

    return $result;
}

# Subroutine for list blankon release :
# ------------------------------------------------------------------------
sub list_rilis {
    my %data = ();
    $data{'tambora'} = '10';
    $data{'uluwatu'} = '11';
    return \%data;
}

# Subroutine for form blankon release :
# ------------------------------------------------------------------------
sub form_boi_rilis {
    my $num_data_rilis;
    my %data = ();
    my $boi_rilis = 'tambora';
    my $status = 0;
    print "\n";
    print "Choose rilis \n";
    print "---" x 15 . "\n";
#    my $daftar_rilis = list_rilis();
#    my $num = 0;
#    my %choose_rilis = ();
#    while (my ($key, $value) = each %{$daftar_rilis}) {
#        my $num_rilis = $num + 1;
#        $choose_rilis{$num_rilis} = $key;
#        print "$num_rilis. $key\n";
#        $num++;
#    }
    print "1. Tambora\n";
    print "2. Uluwatu\n";
    print "Enter number choice : ";
    chomp($num_data_rilis = <STDIN>);
    if ($num_data_rilis ne '' and $num_data_rilis eq '1') {
        $boi_rilis = 'tambora';
        $status = 1;
    } else {
        $status = 1;
        $boi_rilis = 'uluwatu';
    }

    $data{'result'} = $status;
    $data{'data'} = $boi_rilis;

    return \%data;
}

# Subroutine for option help.
# This subroutine using in option "help" on script file "boidev".
# ------------------------------------------------------------------------
sub usage {
    print "\n";
    print "---------" x 8 . "\n";
    print " For Help Command : \n";
    print "---------" x 8 . "\n";
    print "\n";

    print "USAGE :\n";
    print "   boidev <OPTIONS1>\n";
    print " -- or --\n";
    print "   boidev <OPTIONS1> <OPTION2>\n";
    print " -- or --\n";
    print "   boidev <OPTIONS1> <OPTION2> <INPUT>\n";
    print "\n";

    print "For USAGE : boidev <OPTIONS1>\n";
    printf("  %-20s %s\n", "prepare", "Mempersiapkan sistem sebelum melakukan aktiftas pemaket");
    printf("  %-20s %s\n", "gpg-genkey", "Untuk generate key GnuPG");
    printf("  %-20s %s\n", "gpg-auth", "Untuk melihat name, email dan passphrase generate key");
    printf("  %-20s %s\n", "gpg-auth-dec", "Untuk melihat name, email dan passphrase yang tidak diencode");
    printf("  %-20s %s\n", "install_pkg", "Untuk menginstall beberapa paket sebelum melakukan aktiftas pemaket");
    printf("  %-20s %s\n", "bzr2git", "Untuk mengambil data Repository dari Bazaar Server dan dimigrasi ke GitHub");
    print "\n";

    print "For USAGE : boidev bzr2git <OPTIONS2> \n";
    usage_bzr2git();
    print "\n";

    print "For USAGE : boidev bzr2git addpkg <INPUT> \n";
    usage_bzr2git_addpkg();
    print "\n";

    print "For USAGE : boidev bzr2git addpkg-file <INPUT> \n";
    usage_bzr2git_addpkgfile();
    print "\n";
    exit 0;
}
# Subroutine for option help on option bzr2git :
# ------------------------------------------------------------------------
sub usage_bzr2git {
    printf("  %-20s %s\n", "addpkg", "Untuk Menambahkan Paket dalam daftar system aplikasi");
    printf("  %-20s %s\n", "addpkg-file", "Untuk Menambahkan Paket dalam daftar system aplikasi");
    printf("  %-20s %s\n", "list-pkg", "Untuk melihat daftar paket yang sudah terdaftar dalam system.");
    printf("  %-20s %s\n", "branch", "Untuk branch dari repo bazaar berdasarkan list paket yang tersimpan pada system aplikasi");
    printf("  %-20s %s\n", "git-push", "Untuk push ke git berdasarkan semua list paket yang tersimpan pada system");
    printf("  %-20s %s\n", "re-branch", "Untuk branch paket yang ada pada bazaar server");
    printf("  %-20s %s\n", "re-git", "Untuk Deploy ulang ke github");
#    printf("  %-20s %s\n", "", "");
#    printf("  %-20s %s\n", "", "");
}
sub usage_bzr2git_addpkg {
    printf("  %-20s %s\n", "[input_name]", "Berisi nama paket yang akan ditambkan, dan input tidak boleh menggunakan karakter [spasi]");
}
sub usage_bzr2git_addpkgfile {
    printf("  %-20s %s\n", "[input_loc_file]", "Berisi lokasi file daftar paket yang akan ditambahkan. Ex: /your/path/file_name.extension");
}
sub usage_bzr2git_listpkg {

}
sub usage_bzr2git_branch {

}
1;
__END__
