package config;
use strict;
use warnings FATAL => 'all';

# Import Module :
use Term::ReadKey;
use BlankOnDev::Utils::file;

# Version :
require BlankOnDev::Version;
our $VERSION = $BlankOnDev::Version::VERSION;

# Subroutine for option "config" :
# ------------------------------------------------------------------------
sub _config {
    my $confirmation;
    my $gitname;
    my $gitemail;
    my $git_username;
    my $git_password;
    my $home_dir = $ENV{"HOME"};

    # ------------------------------------------------------------------------
    # Check IF git config is exists :
    # ------------------------------------------------------------------------
    if (-e $home_dir.".gitconfig") {
        # Form Confirmation :
        print "You want reconfig github [y/n]:";
        chomp($confirmation = <STDIN>);
        if ($confirmation eq 'y') {

            my $read_fileCfg = BlankOnDev::Utils::file->read($home_dir.".gitconfig");
            my $name_git;
            my $email_git;
            if ($read_fileCfg =~ m/(name)\s(\=)\s(.*)/) {
                $name_git = $3;
            }
            if ($read_fileCfg =~ m/(email)\s(\=)\s(.*)/) {
                $email_git = $3;
            }

            # Print FORM :
            print "Enter your github fullname [$name_git] : ";
            chomp($gitname = <STDIN>);
            print "Enter your github email [$email_git]:";
            chomp($gitemail = <STDIN>);
            if ($gitname eq '') {
                $gitname = $name_git;
            }
            if ($gitemail eq '') {
                $gitemail = $email_git;
            }
            system("git config --global user.name \"$gitname\"");
            system("git config --global user.email \"$gitemail\"");
            system("git config --list");
        }

    } else {

        # GitHub Local Config :
        print "Enter your github fullname : ";
        chomp($gitname = <STDIN>);
        print "Enter your github email :";
        chomp($gitemail = <STDIN>);
        system("git config --global user.name \"$gitname\"");
        system("git config --global user.email \"$gitemail\"");
        system("git config --list");
    }

    # BlankOnDev Tools Setup :
    my $dir_data_boidev = $home_dir . "/.BlankOnDev";
    mkdir($dir_data_boidev);

    # Config Password :
#    print "Enter your github username : ";
#    chomp($git_username = <STDIN>);
#    print "Enter your github account password : ";
#    ReadMode('noecho');
#    $git_password = ReadLine(0);
}
# Subroutine for Bazaar Configure :
# ------------------------------------------------------------------------
sub bzr_config {
    
    
}
1;