#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: lib/Software/License/OrLaterPack.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Software-License-OrLaterPack.
#
#   perl-Software-License-OrLaterPack is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Software-License-OrLaterPack is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Software-License-OrLaterPack. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#   This is dummy main module of `OrLaterPack`, because CPAN does not handle well distributions
#   without a main module. Also, it documents the distribution as a whole.

package Software::License::OrLaterPack;

use strict;     # Let Kwalitee be happy.
use warnings;   # Ditto.
use version 0.77;

# ABSTRACT: Use GNU license with "or later" clause
our $VERSION = 'v0.9.0_01'; # TRIAL VERSION

1;

#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =for :this This is C<OrLaterPack> user manual. Read this if you want to use GNU license with "or later" clause.
#pod
#pod =for :those If you are going to hack or extend C<OrLaterPack> read module documentation, e. g.
#pod L<Software::License::GPL_3::or_later>. General topics like getting source, building, installing,
#pod bug reporting and some others are covered in the F<README> file.
#pod
#pod =head1 SYNOPSIS
#pod
#pod In C<dist.ini>:
#pod
#pod     name             = Foo-Bar
#pod     version          = 0.001
#pod     author           = John Doe <john.doe@example.com>
#pod     license          = GPL_3::or_later
#pod         ; or another license, see the list of provided licenses below
#pod     copyright_holder = John Doe
#pod     copyright_year   = 2015
#pod     …
#pod
#pod Direct usage:
#pod
#pod     use Software::License::GPL_3::or_later;
#pod         # or another license, see the list of provided licenses below
#pod     my $lic =
#pod         Software::License::GPL_3::or_later->new( {
#pod             holder  => 'John Doe',
#pod             year    => '2010',
#pod             program => 'Assa',
#pod         } );
#pod     $lic->abbr;     # returns 'GPLv3+'
#pod     $lic->notice;   # Copyright statement and 3-paragraph GNU license notice
#pod     …
#pod
#pod =head1 LIST OF PROVIDED LICENSES
#pod
#pod =for :list
#pod = L<Software::License::AGPL_3::or_later>
#pod = L<Software::License::GPL_1::or_later>
#pod = L<Software::License::GPL_2::or_later>
#pod = L<Software::License::GPL_3::or_later>
#pod = L<Software::License::LGPL_2_1::or_later>
#pod = L<Software::License::LGPL_3_0::or_later>
#pod
#pod
#pod =head1 CAVEATS
#pod
#pod L<CPAN::Meta::Spec> hardcodes the list of "valid" licenses. In version 2.150001 of the module there
#pod are no "upgradable" GNU licenses, so in CPAN the GPLv3+ will look as ordinal GPLv3 (C<gpl_3>), and
#pod so on.
#pod
#pod =head1 SEE ALSO
#pod
#pod =for :list
#pod = L<Dist::Zilla>
#pod = L<Software::License>
#pod = L<Why should programs say “Version 3 of the GPL or any later version”?|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>
#pod
#pod =head1 COPYRIGHT AND LICENSE
#pod
#pod Copyright (C) 2015 Van de Bugger
#pod
#pod This program is free software: you can redistribute it and/or modify it
#pod under the terms of the GNU General Public License as published by the Free
#pod Software Foundation, either version 3 of the License, or (at your option)
#pod any later version.
#pod
#pod This program is distributed in the hope that it will be useful, but WITHOUT
#pod ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#pod FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#pod more details.
#pod
#pod You should have received a copy of the GNU General Public License along
#pod with this program. If not, see <http://www.gnu.org/licenses/>.
#pod
#pod
#pod =cut

# doc/what.pod #

#pod =encoding UTF-8
#pod
#pod =head1 WHAT?
#pod
#pod C<Software-License-OrLaterPack> is an add-on for C<Software-License>, a set of licenses with "or later" clause
#pod (like C<GPL_3::or_later>). It allows Perl developers (who use C<Dist-Zilla>) to release their work
#pod under the terms of a I<License> version I<N> or (at user option) any later version.
#pod
#pod =cut

# end of file #
# doc/why.pod #

#pod =encoding UTF-8
#pod
#pod =head1 WHY?
#pod
#pod C<Dist-Zilla> is a popular tool for building CPAN distributions. Build process is controlled by
#pod F<dist.ini>, C<Dist-Zilla> configuration file. A distribution author can specify license covering
#pod his work by using C<license> option in F<dist.ini> file:
#pod
#pod     license = NAME
#pod
#pod where I<NAME> is a name of module from L<Software::License> hierarchy.
#pod
#pod C<Software-License> is shipped with a set of popular licenses, from C<Apache_1_1> to C<Zlib>,
#pod including GNU licenses (GPL), including their "Affero" and "Lesser" variants.
#pod
#pod So, if a developer wants to release his work under the terms of the GPL version 3, he should write
#pod in his F<dist.ini>:
#pod
#pod     license = GPL_3
#pod
#pod However, L<Free Software Foundation recommends using clause "license version I<N> or (at your
#pod option) any later version"|>. Unfortunately, C<Software-License>
#pod distribution does not supply (out of the box) a way to express such clause.
#pod
#pod C<Software-License-OrLaterPack> fulfills the lack. If C<Software-License-OrLaterPack> is installed,
#pod a developer can specify in his F<dist.ini>:
#pod
#pod     license = GPL_3::or_later
#pod
#pod =cut

# end of file #


# end of file #

__END__

=pod

=encoding UTF-8

=head1 NAME

Software::License::OrLaterPack - Use GNU license with "or later" clause

=head1 VERSION

Version v0.9.0_01, released on 2015-09-27 13:18 UTC.
This is a B<trial release>.

=head1 WHAT?

C<Software-License-OrLaterPack> is an add-on for C<Software-License>, a set of licenses with "or later" clause
(like C<GPL_3::or_later>). It allows Perl developers (who use C<Dist-Zilla>) to release their work
under the terms of a I<License> version I<N> or (at user option) any later version.

This is C<OrLaterPack> user manual. Read this if you want to use GNU license with "or later" clause.

If you are going to hack or extend C<OrLaterPack> read module documentation, e. g.
L<Software::License::GPL_3::or_later>. General topics like getting source, building, installing,
bug reporting and some others are covered in the F<README> file.

=head1 SYNOPSIS

In C<dist.ini>:

    name             = Foo-Bar
    version          = 0.001
    author           = John Doe <john.doe@example.com>
    license          = GPL_3::or_later
        ; or another license, see the list of provided licenses below
    copyright_holder = John Doe
    copyright_year   = 2015
    …

Direct usage:

    use Software::License::GPL_3::or_later;
        # or another license, see the list of provided licenses below
    my $lic =
        Software::License::GPL_3::or_later->new( {
            holder  => 'John Doe',
            year    => '2010',
            program => 'Assa',
        } );
    $lic->abbr;     # returns 'GPLv3+'
    $lic->notice;   # Copyright statement and 3-paragraph GNU license notice
    …

=head1 WHY?

C<Dist-Zilla> is a popular tool for building CPAN distributions. Build process is controlled by
F<dist.ini>, C<Dist-Zilla> configuration file. A distribution author can specify license covering
his work by using C<license> option in F<dist.ini> file:

    license = NAME

where I<NAME> is a name of module from L<Software::License> hierarchy.

C<Software-License> is shipped with a set of popular licenses, from C<Apache_1_1> to C<Zlib>,
including GNU licenses (GPL), including their "Affero" and "Lesser" variants.

So, if a developer wants to release his work under the terms of the GPL version 3, he should write
in his F<dist.ini>:

    license = GPL_3

However, L<Free Software Foundation recommends using clause "license version I<N> or (at your
option) any later version"|>. Unfortunately, C<Software-License>
distribution does not supply (out of the box) a way to express such clause.

C<Software-License-OrLaterPack> fulfills the lack. If C<Software-License-OrLaterPack> is installed,
a developer can specify in his F<dist.ini>:

    license = GPL_3::or_later

=head1 LIST OF PROVIDED LICENSES

=over 4

=item L<Software::License::AGPL_3::or_later>

=item L<Software::License::GPL_1::or_later>

=item L<Software::License::GPL_2::or_later>

=item L<Software::License::GPL_3::or_later>

=item L<Software::License::LGPL_2_1::or_later>

=item L<Software::License::LGPL_3_0::or_later>

=back

=head1 CAVEATS

L<CPAN::Meta::Spec> hardcodes the list of "valid" licenses. In version 2.150001 of the module there
are no "upgradable" GNU licenses, so in CPAN the GPLv3+ will look as ordinal GPLv3 (C<gpl_3>), and
so on.

=head1 SEE ALSO

=over 4

=item L<Dist::Zilla>

=item L<Software::License>

=item L<Why should programs say “Version 3 of the GPL or any later version”?|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>

=back

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 Van de Bugger

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along
with this program. If not, see <http://www.gnu.org/licenses/>.

=cut
