# lib/Software/Licemse/OrLaterPack.pm #

#pod =encoding UTF-8
#pod
#pod =head1 COPYRIGHT AND LICENSE
#pod
#pod Copyright © 2015 Van de Bugger
#pod
#pod This file is part of Software-License-OrLaterPack.
#pod
#pod Software-License-OrLaterPack is free software: you can redistribute it and/or modify it under the
#pod terms of the GNU General Public License as published by the Free Software Foundation, either
#pod version 3 of the License, or (at your option) any later version.
#pod
#pod Software-License-OrLaterPack is distributed in the hope that it will be useful, but WITHOUT ANY
#pod WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#pod See the GNU General Public License for more details.
#pod
#pod You should have received a copy of the GNU General Public License along with
#pod Software-License-OrLaterPack. If not, see <http://www.gnu.org/licenses/>.
#pod
#pod =cut

#pod =head1 DESCRIPTION
#pod
#pod C<Software-License-OrLaterPack> is an add-on for C<Software-License>.
#pod C<Software-License-OrLaterPack> is a set of few licenses with "or later" clause, e. g.:
#pod C<GPL_3::or_later> (GPLv3+), C<AGPL_3::or_later> (AGPLv3+).
#pod
#pod C<Software::License::OrLaterPack> is dummy module to make CPAN indexer happy.
#pod
#pod =cut

package Software::License::OrLaterPack;

# ABSTRACT: GPLv3+ and AGPLv3+ for Software::License

use 5.008;
use strict;
use warnings;

our $VERSION = '0.006_001'; # TRIAL VERSION

use Software::License::AGPL_3::or_later;
use Software::License::GPL_3::or_later;

1;

# end of file #

__END__

=pod

=encoding UTF-8

=head1 NAME

Software::License::OrLaterPack - GPLv3+ and AGPLv3+ for Software::License

=head1 VERSION

Version 0.006_001.
This is a B<trial release>.

=head1 DESCRIPTION

C<Software-License-OrLaterPack> is an add-on for C<Software-License>.
C<Software-License-OrLaterPack> is a set of few licenses with "or later" clause, e. g.:
C<GPL_3::or_later> (GPLv3+), C<AGPL_3::or_later> (AGPLv3+).

C<Software::License::OrLaterPack> is dummy module to make CPAN indexer happy.

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright © 2015 Van de Bugger

This file is part of Software-License-OrLaterPack.

Software-License-OrLaterPack is free software: you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software Foundation, either
version 3 of the License, or (at your option) any later version.

Software-License-OrLaterPack is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
Software-License-OrLaterPack. If not, see <http://www.gnu.org/licenses/>.

=cut
