# lib/Software/License/AGPL_3/or_later.pm #

#   This file is part of Software-License-OrLaterPack.
#
#   Software-License-OrLaterPack is free software: you can redistribute it
#   and/or modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation, either version 3 of the
#   License, or (at your option) any later version.
#
#   Software-License-OrLaterPack is distributed in the hope that it will be
#   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with Software-License-OrLaterPack.  If not, see
#   <http://www.gnu.org/licenses/>.

package Software::License::AGPL_3::or_later;

# ABSTRACT: AGPLv3+ license for Software::License

use strict;
use warnings;

our $VERSION = '0.006'; # VERSION

use parent __PACKAGE__ =~ m{\A(.*)::or_later\z};
use Software::License::GPL_3::or_later;

# The name of the license.
sub _name { 'the GNU Affero General Public License'; };

# All other methods are exactly the same as methods in `Software::License::GPL_3::or_later`, so let
# us delegate the work.
foreach ( qw{ _version name version notice } ) {
    no strict 'refs';
    *{ $_ } = \&{ "Software::License::GPL_3::or_later::$_" };
}; # foreach

1;

#pod =pod
#pod
#pod =head1 DESCRIPTION
#pod
#pod See documentation on L<Software::License::GPL_3::or_later>. This module does the same but provides
#pod the GNU Affero General Public License.
#pod
#pod =cut

# TODO: It would be nice to eliminate __DATA__ section as well.

=pod

=encoding UTF-8

=head1 NAME

Software::License::AGPL_3::or_later - AGPLv3+ license for Software::License

=head1 VERSION

version 0.006

=head1 DESCRIPTION

See documentation on L<Software::License::GPL_3::or_later>. This module does the same but provides
the GNU Affero General Public License.

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 Van de Bugger

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

__DATA__
__NOTICE__
Copyright (C) {{ $self->year }} {{ $self->holder }}

{{ ucfirst( $self->{ program } ) }} is free software: you can redistribute it and/or modify it
under the terms of {{ $self->_name }} as published by the Free Software Foundation, either version
{{ $self->_version }} of the License, or (at your option) any later version.

{{ ucfirst( $self->{ program } ) }} is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE. See {{ $self->_name }} for more details.

You should have received a copy of {{ $self->_name }} along with {{ $self->{ program } }}. If not,
see <http://www.gnu.org/licenses/>.

__END__

# end of file #
