#!perl -T

use strict;
use warnings;

use Test::More tests => 4;

use Software::License::GPL_3::or_later;
my $l = Software::License::GPL_3::or_later->new( { holder => 'John Doe', year => '2010' } );

#   Make sure there is ", or any later" clause at the end of license name.
#
like( $l->name,  qr{, or any later$} );

#   Check the version.
#
is( $l->version, '3+' );

#   Verify notice. Standard text defined in `Software::Licence` looks like
#
#       This software is Copyright (c) {{$self->year}} by {{$self->holder}}.
#
#       This is free software, licensed under:
#
#           license name
#
#   Notice, defined in `Software::Licence::GPL_3::or_later` differs.
#
like(
    $l->notice,
    qr{
        \A
        \QCopyright (C) 2010 John Doe\E \n
        \n
        \QThis program is free software: \E .*? \n
        \n
        \QThis program is distributed in the hope \E .*? \n
        \n
        \QYou should have received a copy \E .*? \n
        \z
    }sx,
    'It starts with copyright statement and have 3 more paragraphs'
);
my $count = ( $_ = $l->notice ) =~ s{(\bthe\s+GNU\s+General\s+Public\s+License\b)}{}g;
my $n = 3;
is( $count, $n, "phrase \"the GNU General Public License\" should appear $n times" );

# end of file #
