#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/ManifestWriteTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package ManifestWriteTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'Test::Dist::Zilla::Build';

use Test::More;
use Test::Deep qw{ cmp_deeply };
use Perl::Version;
use Path::Tiny;

sub _build_files {
    my ( $self ) = @_;
    return {
        'lib/Dummy.pm' => 'package Dummy.pm; 1;',
    };
};

has writer => (
    isa         => 'Str',
    is          => 'ro',
    default     => 'Manifest::Write',
);

sub _build_message_filter {
    my ( $self ) = @_;
    my $writer = $self->writer;
    return sub {
        map( { ( my $r = $_ ) =~ s{^\[[^\]]*\] }{}; $r } grep( $_ =~ m{^\Q[$writer]\E }, @_ ) );
    };
};

has options => (
    is          => 'ro',
    isa         => 'HashRef',
    default     => sub { {} },
);

has extra_plugins => (
    is          => 'ro',
    isa         => 'ArrayRef',
    default     => sub { [] },
);

sub _build_plugins {
    my ( $self ) = @_;
    return [
        'GatherDir',
        'MetaYAML',
        [ 'Manifest::Write' => $self->options ],
        @{ $self->extra_plugins },
    ];
};

test 'Manifest' => sub {

    my ( $self ) = @_;
    my $expected = $self->expected;

    if ( $self->exception ) {
        plan skip_all => 'exception occured';
    };
    if ( not exists( $expected->{ manifest } ) ) {
        plan skip_all => 'no expected manifest';
    };

    plan tests => 2;

    my $manifest = path( $self->tzil->built_in )->child( 'MANIFEST' );
    my @manifest = $manifest->lines_utf8( { chomp => 1 } );
    $self->_anno_text( 'MANIFEST', @manifest );
    my $head = shift( @manifest );
    like(
        $head,
        qr{
            \A
            \# \Q This file was generated with Dist::Zilla::Plugin::@{ [ $self->writer ] } \E
                @{ [ Perl::Version::REGEX ] }
            \z
        }x,
        'manifest 1st line'
    );
    cmp_deeply( \@manifest, $expected->{ manifest }, 'manifest body' );

};

1;

# end of file #
