#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/ManifestWriteTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package ManifestWriteTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use Moose 2.0800 ();            #   Roles can now override methods from other roles…
use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'PluginTester';

use Test::More;
use Test::Deep qw{ cmp_deeply };

sub build_plugin { 'Manifest::Write' };

#   Expected content of `MANIFEST`, array of lines without "\n".
has exp_manifest => (
    is          => 'ro',
    isa         => 'ArrayRef',
);

test 'check manifest' => sub {
    my ( $self ) = @_;
    if ( not $self->exp_manifest ) {
        plan skip_all => 'no expected manifest';
    };
    my @manifest =  $self->tzil->built_in->file( 'MANIFEST' )->
        slurp( iomode => '<:encoding(UTF-8)', chomp => 1 );
    my $head = shift( @manifest );
    my $plugin = $self->plugin;
    like(
        $head,
        qr{
            \A
            \# \Q This file was generated with Dist::Zilla::Plugin::$plugin \E
                \d+\.\d\d\d(?:_\d\d\d)?
            \z
        }x,
        'manifest head'
    );
    is_deeply( \@manifest, $self->exp_manifest, 'manifest body' );
};

1;

# end of file #
