/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL,	/* 0 */
	OP_STUB,	/* 1 */
	OP_SCALAR,	/* 2 */
	OP_PUSHMARK,	/* 3 */
	OP_WANTARRAY,	/* 4 */
	OP_CONST,	/* 5 */
	OP_GVSV,	/* 6 */
	OP_GV,		/* 7 */
	OP_GELEM,	/* 8 */
	OP_PADSV,	/* 9 */
	OP_PADAV,	/* 10 */
	OP_PADHV,	/* 11 */
	OP_PADANY,	/* 12 */
	OP_PUSHRE,	/* 13 */
	OP_RV2GV,	/* 14 */
	OP_RV2SV,	/* 15 */
	OP_AV2ARYLEN,	/* 16 */
	OP_RV2CV,	/* 17 */
	OP_ANONCODE,	/* 18 */
	OP_PROTOTYPE,	/* 19 */
	OP_REFGEN,	/* 20 */
	OP_SREFGEN,	/* 21 */
	OP_REF,		/* 22 */
	OP_BLESS,	/* 23 */
	OP_BACKTICK,	/* 24 */
	OP_GLOB,	/* 25 */
	OP_READLINE,	/* 26 */
	OP_RCATLINE,	/* 27 */
	OP_REGCMAYBE,	/* 28 */
	OP_REGCRESET,	/* 29 */
	OP_REGCOMP,	/* 30 */
	OP_MATCH,	/* 31 */
	OP_QR,		/* 32 */
	OP_SUBST,	/* 33 */
	OP_SUBSTCONT,	/* 34 */
	OP_TRANS,	/* 35 */
	OP_SASSIGN,	/* 36 */
	OP_AASSIGN,	/* 37 */
	OP_CHOP,	/* 38 */
	OP_SCHOP,	/* 39 */
	OP_CHOMP,	/* 40 */
	OP_SCHOMP,	/* 41 */
	OP_DEFINED,	/* 42 */
	OP_UNDEF,	/* 43 */
	OP_STUDY,	/* 44 */
	OP_POS,		/* 45 */
	OP_PREINC,	/* 46 */
	OP_I_PREINC,	/* 47 */
	OP_PREDEC,	/* 48 */
	OP_I_PREDEC,	/* 49 */
	OP_POSTINC,	/* 50 */
	OP_I_POSTINC,	/* 51 */
	OP_POSTDEC,	/* 52 */
	OP_I_POSTDEC,	/* 53 */
	OP_POW,		/* 54 */
	OP_MULTIPLY,	/* 55 */
	OP_I_MULTIPLY,	/* 56 */
	OP_DIVIDE,	/* 57 */
	OP_I_DIVIDE,	/* 58 */
	OP_MODULO,	/* 59 */
	OP_I_MODULO,	/* 60 */
	OP_REPEAT,	/* 61 */
	OP_ADD,		/* 62 */
	OP_I_ADD,	/* 63 */
	OP_SUBTRACT,	/* 64 */
	OP_I_SUBTRACT,	/* 65 */
	OP_CONCAT,	/* 66 */
	OP_STRINGIFY,	/* 67 */
	OP_LEFT_SHIFT,	/* 68 */
	OP_RIGHT_SHIFT,	/* 69 */
	OP_LT,		/* 70 */
	OP_I_LT,	/* 71 */
	OP_GT,		/* 72 */
	OP_I_GT,	/* 73 */
	OP_LE,		/* 74 */
	OP_I_LE,	/* 75 */
	OP_GE,		/* 76 */
	OP_I_GE,	/* 77 */
	OP_EQ,		/* 78 */
	OP_I_EQ,	/* 79 */
	OP_NE,		/* 80 */
	OP_I_NE,	/* 81 */
	OP_NCMP,	/* 82 */
	OP_I_NCMP,	/* 83 */
	OP_SLT,		/* 84 */
	OP_SGT,		/* 85 */
	OP_SLE,		/* 86 */
	OP_SGE,		/* 87 */
	OP_SEQ,		/* 88 */
	OP_SNE,		/* 89 */
	OP_SCMP,	/* 90 */
	OP_BIT_AND,	/* 91 */
	OP_BIT_XOR,	/* 92 */
	OP_BIT_OR,	/* 93 */
	OP_NEGATE,	/* 94 */
	OP_I_NEGATE,	/* 95 */
	OP_NOT,		/* 96 */
	OP_COMPLEMENT,	/* 97 */
	OP_SMARTMATCH,	/* 98 */
	OP_ATAN2,	/* 99 */
	OP_SIN,		/* 100 */
	OP_COS,		/* 101 */
	OP_RAND,	/* 102 */
	OP_SRAND,	/* 103 */
	OP_EXP,		/* 104 */
	OP_LOG,		/* 105 */
	OP_SQRT,	/* 106 */
	OP_INT,		/* 107 */
	OP_HEX,		/* 108 */
	OP_OCT,		/* 109 */
	OP_ABS,		/* 110 */
	OP_LENGTH,	/* 111 */
	OP_SUBSTR,	/* 112 */
	OP_VEC,		/* 113 */
	OP_INDEX,	/* 114 */
	OP_RINDEX,	/* 115 */
	OP_SPRINTF,	/* 116 */
	OP_ORD,		/* 117 */
	OP_CHR,		/* 118 */
	OP_CRYPT,	/* 119 */
	OP_UCFIRST,	/* 120 */
	OP_LCFIRST,	/* 121 */
	OP_UC,		/* 122 */
	OP_LC,		/* 123 */
	OP_QUOTEMETA,	/* 124 */
	OP_RV2AV,	/* 125 */
	OP_AELEMFAST,	/* 126 */
	OP_AELEM,	/* 127 */
	OP_ASLICE,	/* 128 */
	OP_EACH,	/* 129 */
	OP_VALUES,	/* 130 */
	OP_KEYS,	/* 131 */
	OP_DELETE,	/* 132 */
	OP_EXISTS,	/* 133 */
	OP_RV2HV,	/* 134 */
	OP_HELEM,	/* 135 */
	OP_HSLICE,	/* 136 */
	OP_UNPACK,	/* 137 */
	OP_PACK,	/* 138 */
	OP_SPLIT,	/* 139 */
	OP_JOIN,	/* 140 */
	OP_LIST,	/* 141 */
	OP_LSLICE,	/* 142 */
	OP_ANONLIST,	/* 143 */
	OP_ANONHASH,	/* 144 */
	OP_SPLICE,	/* 145 */
	OP_PUSH,	/* 146 */
	OP_POP,		/* 147 */
	OP_SHIFT,	/* 148 */
	OP_UNSHIFT,	/* 149 */
	OP_SORT,	/* 150 */
	OP_REVERSE,	/* 151 */
	OP_GREPSTART,	/* 152 */
	OP_GREPWHILE,	/* 153 */
	OP_MAPSTART,	/* 154 */
	OP_MAPWHILE,	/* 155 */
	OP_RANGE,	/* 156 */
	OP_FLIP,	/* 157 */
	OP_FLOP,	/* 158 */
	OP_AND,		/* 159 */
	OP_OR,		/* 160 */
	OP_XOR,		/* 161 */
	OP_DOR,		/* 162 */
	OP_COND_EXPR,	/* 163 */
	OP_ANDASSIGN,	/* 164 */
	OP_ORASSIGN,	/* 165 */
	OP_DORASSIGN,	/* 166 */
	OP_METHOD,	/* 167 */
	OP_ENTERSUB,	/* 168 */
	OP_LEAVESUB,	/* 169 */
	OP_LEAVESUBLV,	/* 170 */
	OP_CALLER,	/* 171 */
	OP_WARN,	/* 172 */
	OP_DIE,		/* 173 */
	OP_LINESEQ,	/* 174 */
	OP_NEXTSTATE,	/* 175 */
	OP_DBSTATE,	/* 176 */
	OP_UNSTACK,	/* 177 */
	OP_ENTER,	/* 178 */
	OP_LEAVE,	/* 179 */
	OP_SCOPE,	/* 180 */
	OP_ENTERITER,	/* 181 */
	OP_ITER,	/* 182 */
	OP_ENTERLOOP,	/* 183 */
	OP_LEAVELOOP,	/* 184 */
	OP_RETURN,	/* 185 */
	OP_LAST,	/* 186 */
	OP_NEXT,	/* 187 */
	OP_REDO,	/* 188 */
	OP_DUMP,	/* 189 */
	OP_GOTO,	/* 190 */
	OP_EXIT,	/* 191 */
	OP_SETSTATE,	/* 192 */
	OP_METHOD_NAMED,/* 193 */
	OP_ENTERGIVEN,	/* 194 */
	OP_LEAVEGIVEN,	/* 195 */
	OP_ENTERWHEN,	/* 196 */
	OP_LEAVEWHEN,	/* 197 */
	OP_BREAK,	/* 198 */
	OP_CONTINUE,	/* 199 */
	OP_OPEN,	/* 200 */
	OP_CLOSE,	/* 201 */
	OP_PIPE_OP,	/* 202 */
	OP_FILENO,	/* 203 */
	OP_UMASK,	/* 204 */
	OP_BINMODE,	/* 205 */
	OP_TIE,		/* 206 */
	OP_UNTIE,	/* 207 */
	OP_TIED,	/* 208 */
	OP_SSELECT,	/* 209 */
	OP_SELECT,	/* 210 */
	OP_GETC,	/* 211 */
	OP_READ,	/* 212 */
	OP_PRTF,	/* 213 */
	OP_PRINT,	/* 214 */
	OP_SYSOPEN,	/* 215 */
	OP_SYSSEEK,	/* 216 */
	OP_SYSREAD,	/* 217 */
	OP_SYSWRITE,	/* 218 */
	OP_SEND,	/* 219 */
	OP_RECV,	/* 220 */
	OP_EOF,		/* 221 */
	OP_TELL,	/* 222 */
	OP_SEEK,	/* 223 */
	OP_TRUNCATE,	/* 224 */
	OP_FCNTL,	/* 225 */
	OP_IOCTL,	/* 226 */
	OP_FLOCK,	/* 227 */
	OP_SOCKET,	/* 228 */
	OP_SOCKPAIR,	/* 229 */
	OP_BIND,	/* 230 */
	OP_CONNECT,	/* 231 */
	OP_LISTEN,	/* 232 */
	OP_ACCEPT,	/* 233 */
	OP_SHUTDOWN,	/* 234 */
	OP_GSOCKOPT,	/* 235 */
	OP_SSOCKOPT,	/* 236 */
	OP_GETSOCKNAME,	/* 237 */
	OP_GETPEERNAME,	/* 238 */
	OP_LSTAT,	/* 239 */
	OP_STAT,	/* 240 */
	OP_FTRREAD,	/* 241 */
	OP_FTRWRITE,	/* 242 */
	OP_FTREXEC,	/* 243 */
	OP_FTEREAD,	/* 244 */
	OP_FTEWRITE,	/* 245 */
	OP_FTEEXEC,	/* 246 */
	OP_FTIS,	/* 247 */
	OP_FTSIZE,	/* 248 */
	OP_FTMTIME,	/* 249 */
	OP_FTATIME,	/* 250 */
	OP_FTCTIME,	/* 251 */
	OP_FTROWNED,	/* 252 */
	OP_FTEOWNED,	/* 253 */
	OP_FTZERO,	/* 254 */
	OP_FTSOCK,	/* 255 */
	OP_FTCHR,	/* 256 */
	OP_FTBLK,	/* 257 */
	OP_FTFILE,	/* 258 */
	OP_FTDIR,	/* 259 */
	OP_FTPIPE,	/* 260 */
	OP_FTSUID,	/* 261 */
	OP_FTSGID,	/* 262 */
	OP_FTSVTX,	/* 263 */
	OP_FTLINK,	/* 264 */
	OP_FTTTY,	/* 265 */
	OP_FTTEXT,	/* 266 */
	OP_FTBINARY,	/* 267 */
	OP_CHDIR,	/* 268 */
	OP_CHOWN,	/* 269 */
	OP_CHROOT,	/* 270 */
	OP_UNLINK,	/* 271 */
	OP_CHMOD,	/* 272 */
	OP_UTIME,	/* 273 */
	OP_RENAME,	/* 274 */
	OP_LINK,	/* 275 */
	OP_SYMLINK,	/* 276 */
	OP_READLINK,	/* 277 */
	OP_MKDIR,	/* 278 */
	OP_RMDIR,	/* 279 */
	OP_OPEN_DIR,	/* 280 */
	OP_READDIR,	/* 281 */
	OP_TELLDIR,	/* 282 */
	OP_SEEKDIR,	/* 283 */
	OP_REWINDDIR,	/* 284 */
	OP_CLOSEDIR,	/* 285 */
	OP_FORK,	/* 286 */
	OP_WAIT,	/* 287 */
	OP_WAITPID,	/* 288 */
	OP_SYSTEM,	/* 289 */
	OP_EXEC,	/* 290 */
	OP_KILL,	/* 291 */
	OP_GETPPID,	/* 292 */
	OP_GETPGRP,	/* 293 */
	OP_SETPGRP,	/* 294 */
	OP_GETPRIORITY,	/* 295 */
	OP_SETPRIORITY,	/* 296 */
	OP_TIME,	/* 297 */
	OP_TMS,		/* 298 */
	OP_LOCALTIME,	/* 299 */
	OP_GMTIME,	/* 300 */
	OP_ALARM,	/* 301 */
	OP_SLEEP,	/* 302 */
	OP_SHMGET,	/* 303 */
	OP_SHMCTL,	/* 304 */
	OP_SHMREAD,	/* 305 */
	OP_SHMWRITE,	/* 306 */
	OP_MSGGET,	/* 307 */
	OP_MSGCTL,	/* 308 */
	OP_MSGSND,	/* 309 */
	OP_MSGRCV,	/* 310 */
	OP_SEMOP,	/* 311 */
	OP_SEMGET,	/* 312 */
	OP_SEMCTL,	/* 313 */
	OP_REQUIRE,	/* 314 */
	OP_DOFILE,	/* 315 */
	OP_ENTEREVAL,	/* 316 */
	OP_LEAVEEVAL,	/* 317 */
	OP_ENTERTRY,	/* 318 */
	OP_LEAVETRY,	/* 319 */
	OP_GHBYNAME,	/* 320 */
	OP_GHBYADDR,	/* 321 */
	OP_GHOSTENT,	/* 322 */
	OP_GNBYNAME,	/* 323 */
	OP_GNBYADDR,	/* 324 */
	OP_GNETENT,	/* 325 */
	OP_GPBYNAME,	/* 326 */
	OP_GPBYNUMBER,	/* 327 */
	OP_GPROTOENT,	/* 328 */
	OP_GSBYNAME,	/* 329 */
	OP_GSBYPORT,	/* 330 */
	OP_GSERVENT,	/* 331 */
	OP_SHOSTENT,	/* 332 */
	OP_SNETENT,	/* 333 */
	OP_SPROTOENT,	/* 334 */
	OP_SSERVENT,	/* 335 */
	OP_EHOSTENT,	/* 336 */
	OP_ENETENT,	/* 337 */
	OP_EPROTOENT,	/* 338 */
	OP_ESERVENT,	/* 339 */
	OP_GPWNAM,	/* 340 */
	OP_GPWUID,	/* 341 */
	OP_GPWENT,	/* 342 */
	OP_SPWENT,	/* 343 */
	OP_EPWENT,	/* 344 */
	OP_GGRNAM,	/* 345 */
	OP_GGRGID,	/* 346 */
	OP_GGRENT,	/* 347 */
	OP_SGRENT,	/* 348 */
	OP_EGRENT,	/* 349 */
	OP_GETLOGIN,	/* 350 */
	OP_SYSCALL,	/* 351 */
	OP_LOCK,	/* 352 */
	OP_COMPSUB,	/* 353 */
	OP_CUSTOM,	/* 354 */
	OP_max		
} opcode;

#define MAXO 355
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


#define OP_IS_SOCKET(op)	\
	((op) == OP_ACCEPT || \
	 (op) == OP_BIND || \
	 (op) == OP_CONNECT || \
	 (op) == OP_GETPEERNAME || \
	 (op) == OP_GETSOCKNAME || \
	 (op) == OP_GSOCKOPT || \
	 (op) == OP_LISTEN || \
	 (op) == OP_RECV || \
	 (op) == OP_SEND || \
	 (op) == OP_SHUTDOWN || \
	 (op) == OP_SOCKET || \
	 (op) == OP_SOCKPAIR || \
	 (op) == OP_SSOCKOPT)


#define OP_IS_FILETEST(op)	\
	((op) == OP_FTATIME || \
	 (op) == OP_FTBINARY || \
	 (op) == OP_FTBLK || \
	 (op) == OP_FTCHR || \
	 (op) == OP_FTCTIME || \
	 (op) == OP_FTDIR || \
	 (op) == OP_FTEEXEC || \
	 (op) == OP_FTEOWNED || \
	 (op) == OP_FTEREAD || \
	 (op) == OP_FTEWRITE || \
	 (op) == OP_FTFILE || \
	 (op) == OP_FTIS || \
	 (op) == OP_FTLINK || \
	 (op) == OP_FTMTIME || \
	 (op) == OP_FTPIPE || \
	 (op) == OP_FTREXEC || \
	 (op) == OP_FTROWNED || \
	 (op) == OP_FTRREAD || \
	 (op) == OP_FTRWRITE || \
	 (op) == OP_FTSGID || \
	 (op) == OP_FTSIZE || \
	 (op) == OP_FTSOCK || \
	 (op) == OP_FTSUID || \
	 (op) == OP_FTSVTX || \
	 (op) == OP_FTTEXT || \
	 (op) == OP_FTTTY || \
	 (op) == OP_FTZERO)

/* ex: set ro: */
