# Testing Random::Skew

use strict;
use warnings;

use English qw(-no_match_vars);
use Error::Pure::Utils qw(clean);

use Random::Skew;

use Test::More;
use Test::NoWarnings 'had_no_warnings';



eval {
    Random::Skew->new();
};
ok($EVAL_ERROR =~ /Random::Skew->new: No parameters/,"No parameters gripe");

clean();



eval {
    Random::Skew->new(
        x => 'ouch',
    );
};
ok($EVAL_ERROR =~ /Value .* for key .* must be a number >= 1/,"Must be number>=1 warning 1");

clean();



eval {
    Random::Skew->new(
        okfine => 10,
        toosmall => 0.1,
    );
};
ok($EVAL_ERROR =~ /Value .* for key .* must be a number >= 1/,"Must be number>=1 warning 2");

clean();


my $rs = Random::Skew->new(
    whatever => 5,
);
isa_ok($rs,"Random::Skew");



had_no_warnings;
done_testing( 5 );
