package WWW::MobileCarrierJP::AirHPhone::CIDR;
use strict;
use warnings;
use utf8;
use WWW::MobileCarrierJP::Declare qw/get/;

sub url { 'http://www.willcom-inc.com/ja/service/contents_service/create/center_info/index.html' }

sub scrape {
    my $content = get(__PACKAGE__->url);
    my @parts = split /<font size="2" color="#4c4c4c">/, $content;
    my @result;
    for my $part (@parts) {
        next if $part =~ /削除IPアドレス帯域/;
        while ($part =~ s{([0-9]+)(/[0-9]+)}{}) {
            push @result,
              {
                ip         => $1,
                subnetmask => $2,
              };
        }
    }
    return \@result;
}

1;
__END__

=encoding utf-8

=head1 NAME

WWW::MobileCarrierJP::AirHPhone::CIDR - CIDR(Willcom)

=head1 SYNOPSIS

    use WWW::MobileCarrierJP::AirHPhone::CIDR;
    WWW::MobileCarrierJP::AirHPhone::CIDR->scrape();

=head1 AUTHOR

Tokuhiro Matsuno < tokuhirom gmail com >

=head1 SEE ALSO

L<WWW::MobileCarrierJP>

