use strict;
use warnings;

use inc::Module::Install;

my $dist = 'RDF-RDFa-Parser';
my $fn   = "lib/$dist.pm"; $fn =~ s#-#/#g;

name                $dist;
perl_version_from   $fn;
version_from        $fn;
abstract_from       $fn;
readme_from         $fn;
author              'Toby Inkster <tobyink@cpan.org>';
license             'perl';

test_requires       'Test::More' => '0.61';

requires            'Carp'           => 0;
requires            'Data::Dumper'   => 0;
requires            'Encode'         => 0;
requires            'File::ShareDir' => 0;
requires            'File::Spec'     => 0;
requires            'LWP::UserAgent' => 0;
requires            'RDF::Trine'     => 0.118;
requires            'Storable'       => 0;
requires            'URI::Escape'    => 0;
requires            'URI::URL'       => 0;
requires            'XML::LibXML'    => 1.66;
requires            'XML::RegExp'    => 0;

resources(
	'homepage'   => "http://search.cpan.org/dist/$dist/",
	'repository' => "http://goddamn.co.uk/viewvc/perlmods/$dist/",
	'bugtracker' => "http://rt.cpan.org/Dist/Display.html?Queue=$dist",
	);

write_doap_changes;
write_doap_changes_xml;

install_share;

include 'Test::Signature';
auto_install;
WriteAll(
	'meta' => 1,
	'sign' => 1,
	);

