use strict;
use warnings;

use inc::Module::Install;

my $dist = 'HTML-HTML5-Sanity';
my $fn   = "lib/$dist.pm"; $fn =~ s#-#/#g;

name                $dist;
perl_version_from   $fn;
version_from        $fn;
abstract_from       $fn;
author              'Toby Inkster <tobyink@cpan.org>';
license             'perl';

test_requires       'Test::More'        => '0.61';

requires            'HTML::Entities'    => '3.27';
requires            'Locale::Country'   => '1.06';
requires            'XML::LibXML'       => 0;

resources(
	'homepage'   => "http://search.cpan.org/dist/$dist/",
	'repository' => "http://goddamn.co.uk/viewvc/perlmods/$dist/",
	'bugtracker' => "http://rt.cpan.org/Dist/Display.html?Queue=$dist",
	);
	
system("rapper -i turtle -o rdfxml-abbrev Changes >Changes.xml")
	if $Module::Install::AUTHOR;

include 'Test::Signature';
auto_install;
WriteAll(
	'meta' => 1,
	'sign' => 1,
	);
