package UltraDNS::Type;

=head1 NAME

UltraDNS::Type - Classes for argument and result value data types

=head1 DESCRIPTION

This is an internal module.

=cut

use strict;
use warnings;

use RPC::XML;

my %udns_types = (

    # standard types
    array       => {
        base => 'RPC::XML::array',
    },
    boolean     => {
        base => 'RPC::XML::boolean',
    },
    string      => {
        base => 'RPC::XML::string',
    },
    int         => {
        base => 'RPC::XML::int',
    },

    # type list for arguments generated by mk_methods.pl
    float       => {
        base => 'RPC::XML::double',
    },
    hexint      => {
        base => 'RPC::XML::string',
    },
    hostname    => {
        base => 'RPC::XML::string',
    },
    id          => {
        base => 'RPC::XML::string',
    },
    integer     => {
        base => 'RPC::XML::int',
    },
    ip_address  => {
        base => 'RPC::XML::string',
    },
    ipv6_address    => {
        base => 'RPC::XML::string',
    },
    unsigned    => {
        base => 'RPC::XML::int',
    },
    unsigned_short  => {
        base => 'RPC::XML::int',
    },
    zonename    => {
        base => 'RPC::XML::string',
    },

    # type list for result types not listed above
    soa_record  => {
        base => 'RPC::XML::struct',
    },
    ns_record   => {
        base => 'RPC::XML::struct',
    },
    a_record    => {
        base => 'RPC::XML::struct',
    },
    aaaa_record => {
        base => 'RPC::XML::struct',
    },
    ptr_record  => {
        base => 'RPC::XML::struct',
    },
    cname_record    => {
        base => 'RPC::XML::struct',
    },
    mx_record   => {
        base => 'RPC::XML::struct',
    },
    txt_record  => {
        base => 'RPC::XML::struct',
    },
    ds_record   => {
        base => 'RPC::XML::struct',
    },
    rp_record   => {
        base => 'RPC::XML::struct',
    },
    crs_mail_record => {
        base => 'RPC::XML::struct',
    },
    crs_web_record  => {
        base => 'RPC::XML::struct',
    },
);

for my $type (keys %udns_types) {
    my $info = $udns_types{$type};
    my $class = "UltraDNS::Type::$type";
    my $base = $info->{base} or die "No base class for $type";

    no strict 'refs'; ## no critic
    @{"${class}::ISA"} = ($base);
}

1;
