/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.simr.MatchingPredicate;
import java.util.List;
import java.util.Properties;

public class LcsrMatching
implements MatchingPredicate {
    public static final String LCSR_THRESHOLD = "lcsrThreshold";
    public static final String MINIMUM_WORD_LENGTH = "minimumWordLength";
    private float lcsrThreshold;
    private int minimumWordLength;

    public void setProperties(Properties properties) {
        this.lcsrThreshold = Float.parseFloat(properties.getProperty(LCSR_THRESHOLD));
        this.minimumWordLength = Integer.parseInt(properties.getProperty(MINIMUM_WORD_LENGTH));
    }

    public boolean isMatch(List wordForMatch, List wordToMatch, boolean isXAxis) {
        if (((Object)wordForMatch).equals(wordToMatch)) {
            return true;
        }
        if (wordForMatch.size() < this.minimumWordLength || wordToMatch.size() < this.minimumWordLength) {
            return false;
        }
        int lcsLength = this.computeLcs(wordForMatch, wordToMatch);
        float ratio = wordForMatch.size() > wordToMatch.size() ? (float)lcsLength / (float)wordForMatch.size() : (float)lcsLength / (float)wordToMatch.size();
        return ratio > this.lcsrThreshold;
    }

    public int computeLcs(List wordForMatch, List wordToMatch) {
        int index;
        int wordLengthForMatch = wordForMatch.size();
        int wordLengthToMatch = wordToMatch.size();
        int[][] table = new int[wordLengthForMatch][wordLengthToMatch];
        table[0][0] = wordForMatch.get(0).equals(wordToMatch.get(0)) ? 1 : 0;
        for (index = 1; index < wordLengthForMatch; ++index) {
            table[index][0] = wordForMatch.get(index).equals(wordToMatch.get(0)) ? 1 : table[index - 1][0];
        }
        for (index = 1; index < wordLengthToMatch; ++index) {
            table[0][index] = wordForMatch.get(0).equals(wordToMatch.get(index)) ? 1 : table[0][index - 1];
        }
        for (int outerIndex = 1; outerIndex < wordLengthForMatch; ++outerIndex) {
            for (int innerIndex = 1; innerIndex < wordLengthToMatch; ++innerIndex) {
                table[outerIndex][innerIndex] = wordForMatch.get(outerIndex).equals(wordToMatch.get(innerIndex)) ? table[outerIndex - 1][innerIndex - 1] + 1 : (table[outerIndex][innerIndex - 1] > table[outerIndex - 1][innerIndex] ? table[outerIndex][innerIndex - 1] : table[outerIndex - 1][innerIndex]);
            }
        }
        return table[wordLengthForMatch - 1][wordLengthToMatch - 1];
    }
}

