/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import gnu.trove.TLinkableAdaptor;
import opennlp.common.unify.UnifyFailure;
import org.jdom.Element;

public final class SlashMode
extends TLinkableAdaptor {
    public static final byte All = 0;
    public static final byte ApplicationOnly = 1;
    public static final byte Associative = 2;
    public static final byte Crossing = 3;
    public static final byte CrossingAndAssociative = 4;
    private byte _mode;

    public SlashMode(Element el) {
        String m = el.getAttributeValue("m");
        if (m == null) {
            m = "o";
        }
        this.init(m.charAt(0));
    }

    public SlashMode() {
        this('o');
    }

    public SlashMode(char m) {
        this.init(m);
    }

    private SlashMode(byte m) {
        this._mode = m;
    }

    public SlashMode copy() {
        return new SlashMode(this._mode);
    }

    private void init(char m) {
        switch (m) {
            case 'o': {
                this._mode = 0;
                break;
            }
            case '*': {
                this._mode = 1;
                break;
            }
            case '^': {
                this._mode = (byte)2;
                break;
            }
            case 'x': {
                this._mode = (byte)3;
                break;
            }
            case '%': {
                this._mode = (byte)4;
                break;
            }
            default: {
                this._mode = (byte)2;
            }
        }
    }

    public boolean equals(SlashMode m) {
        return SlashMode.modesMatch(this._mode, m._mode);
    }

    public void unifyCheck(SlashMode m) throws UnifyFailure {
        if (!SlashMode.modesMatch(this._mode, m._mode)) {
            throw new UnifyFailure();
        }
    }

    private static boolean modesMatch(byte m1, byte m2) {
        if (m1 == 0 || m2 == 0) {
            return true;
        }
        if (m1 == 4 && m2 != 1) {
            return true;
        }
        if (m2 == 4 && m1 != 1) {
            return true;
        }
        return m1 == m2;
    }

    public String toString() {
        switch (this._mode) {
            case 0: {
                return "o";
            }
            case 1: {
                return "*";
            }
            case 2: {
                return "^";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "%";
            }
        }
        return "o";
    }
}

