/*
 * Decompiled with CFR 0.152.
 */
package gma.gcalign;

import gma.gcalign.VAL_TABLE;
import gma.gcalign.step;
import gma.gcalign.step_table;
import gma.gcalign.strategy;
import gma.gcalign.strategy_delta;

public class align_core {
    public static final int NUMBER_OF_STRATEGIES = 6;
    int verbose;
    public static final int MEAN_RATIO = 1;
    public static final double VARIANCE_RATIO = 6.8;
    public static final int PENALTY_01 = 450;
    public static final int PENALTY_21 = 230;
    public static final int PENALTY_22 = 440;
    public static final int BIG_DISTANCE = 2500;
    strategy_delta DELTA = new strategy_delta();

    public double normal_cdf(double z_score) {
        double temp = 0.0;
        double t = 1.0 / (1.0 + 0.2316419 * z_score);
        temp = -z_score * z_score / 2.0;
        double pd = 1.0 - 0.3989423 * Math.exp(temp) * ((((1.330274429 * t - 1.821255978) * t + 1.781477937) * t - 0.356563782) * t + 0.31938153) * t;
        return pd;
    }

    public int probability_of_match(float length1, float length2) {
        double result;
        if (length1 == 0.0f && length2 == 0.0f) {
            return 0;
        }
        double mean = (length1 + length2 / 1.0f) / 2.0f;
        double z_score = (double)(1.0f * (length1 - length2)) / Math.sqrt(6.8 * mean);
        if (z_score < 0.0) {
            z_score = -z_score;
        }
        if ((result = 2.0 * (1.0 - this.normal_cdf(z_score))) == 0.0) {
            return 2500;
        }
        return (int)(-100.0 * Math.log(result));
    }

    public int double_sided_cost(strategy newstrategy, VAL_TABLE table1, VAL_TABLE table2, int a, int b) {
        int cost = 0;
        if (strategy.strat.equals("SUBSTITUTION")) {
            cost = this.probability_of_match(table1.get(a), table2.get(b));
        } else if (strategy.strat.equals("DELETION")) {
            cost = this.probability_of_match(table1.get(a), 0.0f) + 450;
        } else if (strategy.strat.equals("INSERTION")) {
            cost = this.probability_of_match(0.0f, table2.get(b)) + 450;
        } else if (strategy.strat.equals("CONTRACTION")) {
            cost = this.probability_of_match(table1.get(a) + table1.get(a + 1), table2.get(b)) + 230;
        } else if (strategy.strat.equals("EXPANSION")) {
            cost = this.probability_of_match(table1.get(a), table2.get(b) + table2.get(b + 1)) + 230;
        } else if (strategy.strat.equals("MELDING")) {
            cost = this.probability_of_match(table1.get(a) + table1.get(a + 1), table2.get(b) + table2.get(b + 1)) + 440;
        }
        return cost;
    }

    public int STEP_MATRIX(int x, int y, int z) {
        int tempAddress = 0;
        tempAddress = x * (z + 1) + y;
        if (tempAddress < 0) {
            tempAddress = 0;
        }
        return tempAddress;
    }

    public step_table align_values(VAL_TABLE table1, VAL_TABLE table2, strategy strategy2, int item1, int item2) {
        int currAddress = 0;
        int costAddress = 0;
        int MAXINT = Integer.MAX_VALUE;
        int index1 = 0;
        int index2 = 0;
        boolean i = false;
        boolean j = false;
        int delta1 = 0;
        int delta2 = 0;
        int best_cost = 0;
        int cost = 0;
        int tj = 0;
        int val = 0;
        strategy currstrategy = new strategy();
        step_table result = new step_table();
        step step2 = new step();
        int counter = (table1.getlength() + 1) * (table2.getlength() + 1);
        step_table step_matrix = new step_table(counter);
        step_matrix.length = counter;
        for (tj = 0; tj < counter; ++tj) {
            step_matrix.STEP[tj] = new step();
            step_matrix.STEP[tj].cost = 0;
            strategy cfr_ignored_0 = step_matrix.STEP[tj].str;
            strategy.svalue = -1;
        }
        currAddress = this.STEP_MATRIX(0, 0, table2.getlength());
        step_matrix.STEP[currAddress] = new step();
        strategy cfr_ignored_1 = step_matrix.STEP[currAddress].str;
        strategy.svalue = -1;
        step_matrix.STEP[currAddress].cost = 0;
        step_matrix.STEP[currAddress].sval = -1;
        step_matrix.STEP[currAddress].setvalue(step_matrix.STEP[currAddress].sval);
        for (index1 = 0; index1 <= table1.getlength(); ++index1) {
            int n = index2 = index1 == 0 ? 1 : 0;
            while (index2 <= table2.getlength()) {
                val = -1;
                String best_strategy = null;
                best_cost = MAXINT;
                int s = strategy.svalue;
                s = -1;
                for (s = 0; s < 6; ++s) {
                    strategy.svalue = s;
                    currstrategy.setvalue(s);
                    delta1 = strategy_delta.item1[s];
                    delta2 = strategy_delta.item2[s];
                    if (index1 < delta1 || index2 < delta2) continue;
                    int a = index1 - delta1;
                    int b = index2 - delta2;
                    costAddress = this.STEP_MATRIX(a, b, table2.getlength());
                    cost = step_matrix.STEP[costAddress].cost + this.double_sided_cost(currstrategy, table1, table2, a, b);
                    if (cost > best_cost) continue;
                    best_strategy = strategy.strat;
                    val = strategy.svalue;
                    best_cost = cost;
                }
                currAddress = this.STEP_MATRIX(index1, index2, table2.getlength());
                step_matrix.STEP[currAddress] = new step();
                strategy cfr_ignored_2 = step_matrix.STEP[currAddress].str;
                strategy.svalue = val;
                step_matrix.STEP[currAddress].cost = best_cost;
                step_matrix.STEP[currAddress].sval = val;
                step_matrix.STEP[currAddress].setvalue(val);
                strategy cfr_ignored_3 = step_matrix.STEP[currAddress].str;
                step_matrix.STEP[currAddress].str.setvalue(strategy.svalue);
                ++index2;
            }
        }
        int newvalue = -1;
        int k = 0;
        int h = 0;
        int l = 0;
        int address = 0;
        int s = 0;
        result = new step_table(Math.max(table1.getlength(), table2.getlength()));
        Object str = null;
        int value = -1;
        int scost = -1;
        index1 = table1.getlength();
        for (index2 = table2.getlength(); index1 > 0 || index2 > 0; index1 -= h, index2 -= l) {
            address = this.STEP_MATRIX(index1, index2, table2.getlength());
            s = value = step_matrix.STEP[address].sval;
            h = strategy_delta.item1[s];
            l = strategy_delta.item2[s];
            result.length = k + 1;
            result.STEP[k] = new step();
            result.STEP[k].str = new strategy();
            result.STEP[k].sval = value;
            result.STEP[k].cost = step_matrix.STEP[address].cost;
            result.STEP[k].setvalue(value);
            ++k;
        }
        result.length = k;
        return result;
    }
}

