package Google::Ads::AdWords::v201702::MutateMembersOperand;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201702' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %userListId_of :ATTR(:get<userListId>);
my %dataType_of :ATTR(:get<dataType>);
my %removeAll_of :ATTR(:get<removeAll>);
my %members_of :ATTR(:get<members>);

__PACKAGE__->_factory(
    [ qw(        userListId
        dataType
        removeAll
        members

    ) ],
    {
        'userListId' => \%userListId_of,
        'dataType' => \%dataType_of,
        'removeAll' => \%removeAll_of,
        'members' => \%members_of,
    },
    {
        'userListId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'dataType' => 'Google::Ads::AdWords::v201702::MutateMembersOperand::DataType',
        'removeAll' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'members' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'userListId' => 'userListId',
        'dataType' => 'dataType',
        'removeAll' => 'removeAll',
        'members' => 'members',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201702::MutateMembersOperand

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MutateMembersOperand from the namespace https://adwords.google.com/api/adwords/rm/v201702.

Operand containing user list id and members to be added or removed. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * userListId


=item * dataType


=item * removeAll


=item * members




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

