use strict;
use warnings;

use Test::More;

plan tests => 30;

use Dancer qw/ :syntax :tests /;
use Dancer::Test;

# verify that all test helper functions are behaving the way
# we want

our $route = '/marco';

get $route => sub { 'polo' };

my $users = {};
my $last_id = 0;

get '/user/:id' => sub {
    my $id = params->{'id'};
    { user => $users->{$id} };
};

post '/user' => sub {
    my $id   = ++$last_id;
    my $user = params('body');
    $user->{id} = $id;
    $users->{$id} = $user;

    { user => $users->{$id} };
};

del '/user/:id' => sub {
    my $id      = params->{'id'};
    my $deleted = $users->{$id};
    delete $users->{$id};
    { user => $deleted };
};

my $resp = dancer_response GET => '/marco';

my @req = ( [ GET => $route ], $route, $resp );

test_helping_functions( $_ ) for @req;

response_doesnt_exist [ GET => '/satisfaction' ], 'response_doesnt_exist';
response_exists [ GET => '/marco' ], 'response_exists';

sub test_helping_functions {
    my $req = shift;

    response_exists $req;
    response_status_is $req => 200;
    response_status_isnt $req => 613;

    response_content_is $req => 'polo';
    response_content_isnt $req => 'stuff';
    response_content_is_deeply $req => 'polo';
    response_content_like $req => qr/.ol/;
    response_content_unlike $req => qr/\d/;
}

## POST
my $r = dancer_response( POST => '/user', { body => { name => 'Alexis' } } );
is_deeply $r->{content}, { user => { id => 1, name => "Alexis" } },
  "create user works";

$r = dancer_response( GET => '/user/1' );
is_deeply $r->{content}, { user => { id => 1, name => 'Alexis' } },
  "user 1 is defined";

$r = dancer_response( DELETE => '/user/1' );
is_deeply $r->{content},
  { user => { id => 1, name => 'Alexis', } },
  "user 1 is deleted";

$r = dancer_response(
    POST => '/user',
    { body => { name => 'Franck Cuny' } }
);
is_deeply $r->{content}, { user => { id => 2, name => "Franck Cuny" } },
  "id is correctly increased";

