use warnings;
use strict;

use Carp;
use IPC::Shareable;
use Test::More;

my $sv;

my $awake = 0;
local $SIG{ALRM} = sub { $awake = 1 };

my $pid = fork;
defined $pid or die "Cannot fork: $!";

if ($pid == 0) {
    # child

    sleep unless $awake;

    tie $sv, 'IPC::Shareable', 'data', { destroy => 0 };
    $sv = 'foo';

    exit;
} else {
    # parent

    tie $sv, 'IPC::Shareable', {
        key => 'data',
        create => 1,
        destroy => 1,
    };

    $sv = 'bar';

    is $sv, 'bar', "in parent: parent set SV to 'bar' ok";

    kill ALRM => $pid;
    waitpid($pid, 0);

    is $sv, 'foo', "in parent: child set SV to 'foo' ok";
}

done_testing();
