use strict;
use warnings;

use Test::More;
use IPC::Shareable;

my $mod = 'IPC::Shareable';

tie my %hv, $mod, {destroy => 1};

my %check;
my (@k, @v, %used);

for (0..9) {
    my $n;

    do {
        $n = int(rand(26));
    } while (exists $used{$n});

    $used{$n}++;

    push @k, ('a' .. 'z')[$n];
    push @v, ('A' .. 'Z')[$n];
}
@check{@k} = @v;

while (my($k, $v) = each %check) {
    $hv{$k} = $v;
}

is keys(%hv), 11, "hv has proper number of keys";

while (my($k, $v) = each %check) {
    is $hv{$k}, $v, "check hash $k matches hv val $v";
}

# --- EXISTS

$hv{there} = undef;
is exists($hv{there}), 1, "exists() works ok";
is defined($hv{there}), '', "defined with undef val ok";

# --- DELETE

$hv{there} = 'yes';
is defined($hv{there}), 1, "defined with val ok";

delete $hv{there};

is exists($hv{there}), '', "delete removes hash key and value";

# --- CLEAR

%hv = ();
is keys(%hv), 1, "clearing a hash works ok";
is exists($hv{__ipc__}), 1, "__ipc__ key still exists";

IPC::Shareable->clean_up;

is %hv, '', "hash deleted after clean_up()";

done_testing();


