use warnings;
use strict;
use feature 'say';

use Data::Dumper;
use IPC::Shareable;
use Test::More;

my %hash;

my $s = tie %hash, 'IPC::Shareable', {
    key => 1111,
    create => 1,
    destroy => 1,
    persist => 1
};

$hash{a} = 1;
$hash{b} = 'blah';
#$hash{c} = [qw(1 2 3)];
$hash{c} = {a => 1};

is $hash{a}, 1, "hash key 'a' ok";
is $hash{b}, 'blah', "hash key 'b' ok";
#is ref $hash{c}, 'ARRAY', "hash key 'c' is an ARRAY ok";
#
#my $v = 1;
#for (@{ $hash{c} }){
#    is $_, $v, "\$hash{c} element $_ is $v ok";
#    $v++;
#}

$s->clean_up;
$s->clean_up_all;

is %hash, 1, "after clean_up and clean_up_all(), hash still exists";

done_testing();

