# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use v5.16.0;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "A new object system for Perl 5",
  "AUTHOR" => "Stevan Little <stevan.little\@iinteractive.com>, Jesse Luehrs <doy\@tozt.net>, Florian Ragwitz <rafl\@debian.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Devel::CallParser" => 0,
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "mop",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.016000",
  "NAME" => "mop",
  "PREREQ_PM" => {
    "Devel::CallParser" => 0,
    "Hash::Util::FieldHash" => 0,
    "Scalar::Util" => 0,
    "XSLoader" => 0,
    "mro" => 0,
    "overload" => 0,
    "parent" => 0,
    "strict" => 0,
    "version" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "B::Deparse" => 0,
    "Capture::Tiny" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "Test::More" => "0.88",
    "blib" => 0,
    "if" => 0,
    "lib" => 0
  },
  "VERSION" => "0.02",
  "test" => {
    "TESTS" => "t/*.t t/001-examples/*.t t/010-basics/*.t t/020-methods/*.t t/030-roles/*.t t/050-non-mop-integration/*.t t/100-internals/*.t t/110-oddities/*.t t/120-bugs/*.t t/150-parser-tests/*.t t/200-meta/*.t t/300-ext/Option/*.t t/300-ext/Test-BuilderX/*.t t/400-traits/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ($ENV{RELEASE_TESTING}) {
  my %DEVELOP_REQUIRES = (
    "Devel::StackTrace" => 0,
    "Moose" => 0,
    "Moose::Util::TypeConstraints" => 0,
    "Package::Stash::XS" => "0.27",
    "Path::Class" => 0,
    "Pod::Coverage::TrustPod" => 0,
    "Test::EOL" => 0,
    "Test::NoTabs" => 0,
    "Test::Pod" => "1.41",
    "Test::Pod::Coverage" => "1.08"
  );

  $WriteMakefileArgs{BUILD_REQUIRES} = {
    %{ $WriteMakefileArgs{BUILD_REQUIRES} },
    %DEVELOP_REQUIRES,
  };
}

use Devel::CallParser 'callparser1_h', 'callparser_linkable';
use File::Spec::Functions 'abs2rel';
{
    open my $fh, '>', 'callparser1.h' or die $!;
    print { $fh } callparser1_h or die $!;
    close $fh or die $!;
}
my @linkable = map { abs2rel($_) } callparser_linkable;
unshift @linkable, '$(BASEEXT)$(OBJ_EXT)' if @linkable;
$WriteMakefileArgs{OBJECT} = join(' ', @linkable) if @linkable;
$WriteMakefileArgs{clean}{FILES} .= ' callparser1.h';

WriteMakefile(%WriteMakefileArgs);



