#!perl -T
use strict;
use warnings;

use Test::More tests => 16;
use Test::Exception;
use Test::NoWarnings;

BEGIN {
    use_ok
        'Try::Chain',
        qw( $call_m $fetch_i $fetch_k );
}

sub new {
    return bless {}, __PACKAGE__;
}
sub nothing {
    return;
}
sub string {
    return 'foo';
}
sub list {
    return qw( bar baz );
}
sub array_ref {
    return [ 'item' ];
}
sub hash_ref {
    return { key => 'value' };
}

OK: {
    lives_ok
        sub {
            my $scalar = __PACKAGE__->new->$call_m('string');
            is
                $scalar,
                'foo',
                'call method';
        },
        q{...->new->$call_m('string')};
    lives_ok
        sub {
            my $scalar = __PACKAGE__->array_ref->$fetch_i(0);
            is
                $scalar,
                'item',
                'fetch index';
        },
        q{...->array_ref->$fetch_i(0)};
    lives_ok
        sub {
            my $scalar = __PACKAGE__->hash_ref->$fetch_k('key');
            is
                $scalar,
                'value',
                'fetch key';
        },
        q{...->hash_ref->$fetch_k('key')};
}

BROKEN_CHAIN: {
    lives_ok
        sub {
            my $scalar = undef()->$call_m('nothing')->$call_m('string');
            is
                $scalar,
                undef,
                'undef 1st';
        },
        q{undef()->$call_m('nothing')->$call_m('string')};
    lives_ok
        sub {
            my $scalar = __PACKAGE__->$call_m('nothing')->$call_m('string');
            is
                $scalar,
                undef,
                'undef 2nd';
        },
        q{...->$call_m('nothing')->$call_m('string')};
    lives_ok
        sub {
            my $scalar = __PACKAGE__->$call_m('nothing')->$fetch_i(0);
            is
                $scalar,
                undef,
                'fetch index';
        },
        q{...->$call_m('nothing')->$fetch_i(0)};
    lives_ok
        sub {
            my $scalar = __PACKAGE__->$call_m('nothing')->$fetch_k('key');
            is
                $scalar,
                undef,
                'fetch key';
        },
        q{...->$call_m('nothing')->$fetch_k('key')};
}
