#!/usr/bin/perl -T

# test if untainting $ENV{PERL5LIB} keeps test from failing

use lib '.'; use lib 't';

require v5.14.0;

use Cwd;
use Config;
use File::Spec;
use File::Temp qw(tempdir);

use Test::More tests => 1;

my $tname = "a4";

if ($ENV{'PERL5LIB'}) {
  # untaint the environment variable before trying the test
  $ENV{'PER5LIB'} =~ /^(.*)\z/s;
  $ENV{'PERL5LIB'} = $1;
  my @pathdirs  = split($Config{path_sep}, $ENV{'PERL5LIB'});
  my $pathdir = $pathdirs[0];
  (-d $pathdir) and File::Spec->file_name_is_absolute($pathdir);
}

my $workdir = tempdir("$tname.XXXXXX", DIR => "log");
die "FATAL: failed to create workdir: $!" unless -d $workdir;

ok((-d $workdir), 'tempdir test');
