# $Id: Flat.pm,v 0.06 2004/01/18 22:15:36 sts Exp $

package Sort::Flat;

use base qw(Exporter);
use strict 'vars';
use warnings;

our $VERSION = '0.06';

our @EXPORT_OK = qw(sort_f reverse_f);

our $cmp;

sub sort_f { local $cmp = '+'; &_sort_flat; }
sub reverse_f { &_sort_flat }

sub _sort_flat {
    no warnings;
    return $cmp eq '+'
      ? sort {lc($a) cmp lc($b)} @_
      : sort {lc($b) cmp lc($a)} @_;
}

1;
__END__

=head1 NAME

Sort::Flat - a case-insensitive sort.

=head1 SYNOPSIS

 use Sort::Flat qw(sort_f reverse_f);

 @arr1 = qw(ABC def JKL ghi PQRS mno);

 @arr2 = sort_f @arr1;
 @arr2 = reverse_f @arr1;

=head1 DESCRIPTION

C<Sort::Flat> implements case-insensitive sorting by lowercasering 
items within an array each time an array has to be sorted; 
C<sort_f & reverse_f> are shortcuts to perl's C<sort>.

C<sort_f> is equivalent to using C<sort {lc($a) cmp lc($b)}>,
while C<reverse_f> is equivalent to using C<sort {lc($b) cmp lc($a)}>.

=head1 EXPORT

C<sort_f & reverse_f> upon request.

=cut

=head1 SEE ALSO

perl(1)

=head1 LICENSE

This program is free software; 
you may redistribute it and/or modify it under the same terms as Perl itself.

=head1 AUTHOR

Steven Schubiger

=cut
