#!/usr/bin/perl -w

require 5.010000;

$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
  $dir="./lib";
  $tdir="t";
} elsif ( -f "test.pl" ) {
  require "test.pl";
  $dir="../lib";
  $tdir=".";
} else {
  die "ERROR: cannot find test.pl\n";
}

unshift(@INC,$dir);
use Date::Manip::Base;

sub test {
  (@test)=@_;
  @ret = $obj->calc_date_time(@test);
  return @ret;
}

$obj = new Date::Manip::Base;

$tests="

[] 2000,01,15,12,00,00
[] 1,0,0
   ~
   [] 2000,1,15,13,0,0

[] 2000,01,15,12,00,00
[] -1,0,0
   ~
   [] 2000,1,15,11,0,0

[] 2000,01,15,12,00,00
[] 1,1,0
   ~
   [] 2000,1,15,13,1,0

[] 2000,01,15,12,00,00
[] -1,-1,0
   ~
   [] 2000,1,15,10,59,0

[] 2000,01,15,12,00,00
[] 1,1,1
   ~
   [] 2000,1,15,13,1,1

[] 2000,01,15,12,00,00
[] -1,-1,-1
   ~
   [] 2000,1,15,10,58,59

[] 2000,01,15,12,00,00
[] 0,1,0
   ~
   [] 2000,1,15,12,1,0

[] 2000,01,15,12,00,00
[] 0,-1,0
   ~
   [] 2000,1,15,11,59,0

[] 2000,01,15,12,00,00
[] 0,1,1
   ~
   [] 2000,1,15,12,1,1

[] 2000,01,15,12,00,00
[] 0,-1,-1
   ~
   [] 2000,1,15,11,58,59

[] 2000,01,15,12,00,00
[] 0,0,1
   ~
   [] 2000,1,15,12,0,1

[] 2000,01,15,12,00,00
[] 0,0,-1
   ~
   [] 2000,1,15,11,59,59

[] 2000,01,15,12,00,00
[] +24,0,0
   ~
   [] 2000,1,16,12,0,0

[] 2000,01,15,12,00,00
[] -24,0,0
   ~
   [] 2000,1,14,12,0,0

[] 1999,12,31,12,00,00
[] +24,0,0
   ~
   [] 2000,1,1,12,0,0

[] 2000,01,01,12,00,00
[] -24,0,0
   ~
   [] 1999,12,31,12,0,0

[] 2000,12,31,12,00,00
[] +24,0,0
   ~
   [] 2001,1,1,12,0,0

[] 2000,01,15,12,00,00
[] +49,1,0
   ~
   [] 2000,1,17,13,1,0

";

print "calc_date_time...\n";
test_Func(\&test,$tests,$runtests);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:

