package Date::Manip::TZ::afwind00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:41 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::afwind00 - Support for the Africa/Windhoek time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.02";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,1,8,24],'+01:08:24',[1,8,24],
          'LMT',0,[1892,2,7,22,51,35],[1892,2,7,23,59,59] ],
     ],
   1892 =>
     [
        [ [1892,2,7,22,51,36],[1892,2,8,0,21,36],'+01:30:00',[1,30,0],
          'SWAT',0,[1903,2,28,22,29,59],[1903,2,28,23,59,59] ],
     ],
   1903 =>
     [
        [ [1903,2,28,22,30,0],[1903,3,1,0,30,0],'+02:00:00',[2,0,0],
          'SAST',0,[1942,9,19,23,59,59],[1942,9,20,1,59,59] ],
     ],
   1942 =>
     [
        [ [1942,9,20,0,0,0],[1942,9,20,3,0,0],'+03:00:00',[3,0,0],
          'SAST',1,[1943,3,20,22,59,59],[1943,3,21,1,59,59] ],
     ],
   1943 =>
     [
        [ [1943,3,20,23,0,0],[1943,3,21,1,0,0],'+02:00:00',[2,0,0],
          'SAST',0,[1990,3,20,21,59,59],[1990,3,20,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,3,20,22,0,0],[1990,3,21,0,0,0],'+02:00:00',[2,0,0],
          'CAT',0,[1994,4,2,21,59,59],[1994,4,2,23,59,59] ],
     ],
   1994 =>
     [
        [ [1994,4,2,22,0,0],[1994,4,2,23,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1994,9,4,0,59,59],[1994,9,4,1,59,59] ],
        [ [1994,9,4,1,0,0],[1994,9,4,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[1995,4,1,23,59,59],[1995,4,2,1,59,59] ],
     ],
   1995 =>
     [
        [ [1995,4,2,0,0,0],[1995,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1995,9,3,0,59,59],[1995,9,3,1,59,59] ],
        [ [1995,9,3,1,0,0],[1995,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[1996,4,6,23,59,59],[1996,4,7,1,59,59] ],
     ],
   1996 =>
     [
        [ [1996,4,7,0,0,0],[1996,4,7,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1996,9,1,0,59,59],[1996,9,1,1,59,59] ],
        [ [1996,9,1,1,0,0],[1996,9,1,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[1997,4,5,23,59,59],[1997,4,6,1,59,59] ],
     ],
   1997 =>
     [
        [ [1997,4,6,0,0,0],[1997,4,6,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1997,9,7,0,59,59],[1997,9,7,1,59,59] ],
        [ [1997,9,7,1,0,0],[1997,9,7,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[1998,4,4,23,59,59],[1998,4,5,1,59,59] ],
     ],
   1998 =>
     [
        [ [1998,4,5,0,0,0],[1998,4,5,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1998,9,6,0,59,59],[1998,9,6,1,59,59] ],
        [ [1998,9,6,1,0,0],[1998,9,6,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[1999,4,3,23,59,59],[1999,4,4,1,59,59] ],
     ],
   1999 =>
     [
        [ [1999,4,4,0,0,0],[1999,4,4,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[1999,9,5,0,59,59],[1999,9,5,1,59,59] ],
        [ [1999,9,5,1,0,0],[1999,9,5,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2000,4,1,23,59,59],[2000,4,2,1,59,59] ],
     ],
   2000 =>
     [
        [ [2000,4,2,0,0,0],[2000,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2000,9,3,0,59,59],[2000,9,3,1,59,59] ],
        [ [2000,9,3,1,0,0],[2000,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2001,3,31,23,59,59],[2001,4,1,1,59,59] ],
     ],
   2001 =>
     [
        [ [2001,4,1,0,0,0],[2001,4,1,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2001,9,2,0,59,59],[2001,9,2,1,59,59] ],
        [ [2001,9,2,1,0,0],[2001,9,2,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2002,4,6,23,59,59],[2002,4,7,1,59,59] ],
     ],
   2002 =>
     [
        [ [2002,4,7,0,0,0],[2002,4,7,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2002,9,1,0,59,59],[2002,9,1,1,59,59] ],
        [ [2002,9,1,1,0,0],[2002,9,1,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2003,4,5,23,59,59],[2003,4,6,1,59,59] ],
     ],
   2003 =>
     [
        [ [2003,4,6,0,0,0],[2003,4,6,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2003,9,7,0,59,59],[2003,9,7,1,59,59] ],
        [ [2003,9,7,1,0,0],[2003,9,7,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2004,4,3,23,59,59],[2004,4,4,1,59,59] ],
     ],
   2004 =>
     [
        [ [2004,4,4,0,0,0],[2004,4,4,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2004,9,5,0,59,59],[2004,9,5,1,59,59] ],
        [ [2004,9,5,1,0,0],[2004,9,5,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2005,4,2,23,59,59],[2005,4,3,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,4,3,0,0,0],[2005,4,3,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2005,9,4,0,59,59],[2005,9,4,1,59,59] ],
        [ [2005,9,4,1,0,0],[2005,9,4,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2006,4,1,23,59,59],[2006,4,2,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,4,2,0,0,0],[2006,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2006,9,3,0,59,59],[2006,9,3,1,59,59] ],
        [ [2006,9,3,1,0,0],[2006,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2007,3,31,23,59,59],[2007,4,1,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,4,1,0,0,0],[2007,4,1,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2007,9,2,0,59,59],[2007,9,2,1,59,59] ],
        [ [2007,9,2,1,0,0],[2007,9,2,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2008,4,5,23,59,59],[2008,4,6,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,6,0,0,0],[2008,4,6,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2008,9,7,0,59,59],[2008,9,7,1,59,59] ],
        [ [2008,9,7,1,0,0],[2008,9,7,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2009,4,4,23,59,59],[2009,4,5,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,4,5,0,0,0],[2009,4,5,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2009,9,6,0,59,59],[2009,9,6,1,59,59] ],
        [ [2009,9,6,1,0,0],[2009,9,6,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2010,4,3,23,59,59],[2010,4,4,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,4,4,0,0,0],[2010,4,4,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2010,9,5,0,59,59],[2010,9,5,1,59,59] ],
        [ [2010,9,5,1,0,0],[2010,9,5,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2011,4,2,23,59,59],[2011,4,3,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,3,0,0,0],[2011,4,3,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2011,9,4,0,59,59],[2011,9,4,1,59,59] ],
        [ [2011,9,4,1,0,0],[2011,9,4,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2012,3,31,23,59,59],[2012,4,1,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,4,1,0,0,0],[2012,4,1,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2012,9,2,0,59,59],[2012,9,2,1,59,59] ],
        [ [2012,9,2,1,0,0],[2012,9,2,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2013,4,6,23,59,59],[2013,4,7,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,4,7,0,0,0],[2013,4,7,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2013,9,1,0,59,59],[2013,9,1,1,59,59] ],
        [ [2013,9,1,1,0,0],[2013,9,1,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2014,4,5,23,59,59],[2014,4,6,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,4,6,0,0,0],[2014,4,6,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2014,9,7,0,59,59],[2014,9,7,1,59,59] ],
        [ [2014,9,7,1,0,0],[2014,9,7,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2015,4,4,23,59,59],[2015,4,5,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,4,5,0,0,0],[2015,4,5,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2015,9,6,0,59,59],[2015,9,6,1,59,59] ],
        [ [2015,9,6,1,0,0],[2015,9,6,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2016,4,2,23,59,59],[2016,4,3,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,3,0,0,0],[2016,4,3,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2016,9,4,0,59,59],[2016,9,4,1,59,59] ],
        [ [2016,9,4,1,0,0],[2016,9,4,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2017,4,1,23,59,59],[2017,4,2,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,4,2,0,0,0],[2017,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2017,9,3,0,59,59],[2017,9,3,1,59,59] ],
        [ [2017,9,3,1,0,0],[2017,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2018,3,31,23,59,59],[2018,4,1,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,4,1,0,0,0],[2018,4,1,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2018,9,2,0,59,59],[2018,9,2,1,59,59] ],
        [ [2018,9,2,1,0,0],[2018,9,2,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2019,4,6,23,59,59],[2019,4,7,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,4,7,0,0,0],[2019,4,7,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2019,9,1,0,59,59],[2019,9,1,1,59,59] ],
        [ [2019,9,1,1,0,0],[2019,9,1,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2020,4,4,23,59,59],[2020,4,5,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,4,5,0,0,0],[2020,4,5,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2020,9,6,0,59,59],[2020,9,6,1,59,59] ],
        [ [2020,9,6,1,0,0],[2020,9,6,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2021,4,3,23,59,59],[2021,4,4,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,4,4,0,0,0],[2021,4,4,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2021,9,5,0,59,59],[2021,9,5,1,59,59] ],
        [ [2021,9,5,1,0,0],[2021,9,5,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2022,4,2,23,59,59],[2022,4,3,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,3,0,0,0],[2022,4,3,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2022,9,4,0,59,59],[2022,9,4,1,59,59] ],
        [ [2022,9,4,1,0,0],[2022,9,4,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2023,4,1,23,59,59],[2023,4,2,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,4,2,0,0,0],[2023,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2023,9,3,0,59,59],[2023,9,3,1,59,59] ],
        [ [2023,9,3,1,0,0],[2023,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2024,4,6,23,59,59],[2024,4,7,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,4,7,0,0,0],[2024,4,7,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2024,9,1,0,59,59],[2024,9,1,1,59,59] ],
        [ [2024,9,1,1,0,0],[2024,9,1,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2025,4,5,23,59,59],[2025,4,6,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,4,6,0,0,0],[2025,4,6,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2025,9,7,0,59,59],[2025,9,7,1,59,59] ],
        [ [2025,9,7,1,0,0],[2025,9,7,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2026,4,4,23,59,59],[2026,4,5,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,4,5,0,0,0],[2026,4,5,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2026,9,6,0,59,59],[2026,9,6,1,59,59] ],
        [ [2026,9,6,1,0,0],[2026,9,6,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2027,4,3,23,59,59],[2027,4,4,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,4,4,0,0,0],[2027,4,4,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2027,9,5,0,59,59],[2027,9,5,1,59,59] ],
        [ [2027,9,5,1,0,0],[2027,9,5,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2028,4,1,23,59,59],[2028,4,2,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,4,2,0,0,0],[2028,4,2,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2028,9,3,0,59,59],[2028,9,3,1,59,59] ],
        [ [2028,9,3,1,0,0],[2028,9,3,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2029,3,31,23,59,59],[2029,4,1,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,4,1,0,0,0],[2029,4,1,1,0,0],'+01:00:00',[1,0,0],
          'WAT',0,[2029,9,2,0,59,59],[2029,9,2,1,59,59] ],
        [ [2029,9,2,1,0,0],[2029,9,2,3,0,0],'+02:00:00',[2,0,0],
          'WAST',1,[2030,4,6,23,59,59],[2030,4,7,1,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+02:00:00',
                'stdoff' => '+01:00:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'WAT',
                        },
                '09' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'WAST',
                        },

               },
);

1;
