#!perl
#
# This file is part of Dist-Zilla-PluginBundle-Author-RWSTAUNER
#
# This software is copyright (c) 2010 by Randy Stauner.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#

use strict;
use warnings;

# This test was generated by Dist::Zilla::Plugin::Test::ReportPrereqs 0.013

use Test::More tests => 1;

use ExtUtils::MakeMaker;
use File::Spec::Functions;
use List::Util qw/max/;
use version;

# hide optional CPAN::Meta modules from prereq scanner
# and check if they are available
my $cpan_meta = "CPAN::Meta";
my $cpan_meta_req = "CPAN::Meta::Requirements";
my $HAS_CPAN_META = eval "require $cpan_meta"; ## no critic
my $HAS_CPAN_META_REQ = eval "require $cpan_meta_req; $cpan_meta_req->VERSION('2.120900')";

# Verify requirements?
my $DO_VERIFY_PREREQS = 1;

sub _merge_requires {
    my ($collector, $prereqs) = @_;
    for my $phase ( qw/configure build test runtime develop/ ) {
        next unless exists $prereqs->{$phase};
        if ( my $req = $prereqs->{$phase}{'requires'} ) {
            my $cmr = CPAN::Meta::Requirements->from_string_hash( $req );
            $collector->add_requirements( $cmr );
        }
    }
}

my %include = map {; $_ => 1 } qw(

);

my %exclude = map {; $_ => 1 } qw(

);

# Add static prereqs to the included modules list
my $static_prereqs = do { my $x = {
       'build' => {
                    'requires' => {
                                    'Module::Build' => '0.3601'
                                  }
                  },
       'configure' => {
                        'requires' => {
                                        'File::ShareDir::Install' => '0.03',
                                        'Module::Build' => '0.3601'
                                      }
                      },
       'develop' => {
                      'requires' => {
                                      'Pod::Coverage::TrustPod' => '0',
                                      'Test::CPAN::Changes' => '0.19',
                                      'Test::CPAN::Meta' => '0',
                                      'Test::Kwalitee' => '1.12',
                                      'Test::More' => '0',
                                      'Test::NoTabs' => '0',
                                      'Test::Pod' => '1.41',
                                      'Test::Pod::Coverage' => '1.08'
                                    }
                    },
       'runtime' => {
                      'recommends' => {
                                        'Devel::Cover' => '1.00',
                                        'Dist::Zilla::App::Command::cover' => '0',
                                        'Dist::Zilla::Plugin::DualBuilders' => '1.001',
                                        'Dist::Zilla::Plugin::TaskWeaver' => '0.101620',
                                        'Dist::Zilla::Plugin::Test::PodSpelling' => '2'
                                      },
                      'requires' => {
                                      'Data::Section' => '0',
                                      'Dist::Zilla' => '5',
                                      'Dist::Zilla::Plugin::Authority' => '1.005',
                                      'Dist::Zilla::Plugin::AutoPrereqs' => '0',
                                      'Dist::Zilla::Plugin::Bootstrap::lib' => '0',
                                      'Dist::Zilla::Plugin::Bugtracker' => '0',
                                      'Dist::Zilla::Plugin::CheckChangesHasContent' => '0.006',
                                      'Dist::Zilla::Plugin::CheckExtraTests' => '0',
                                      'Dist::Zilla::Plugin::CheckMetaResources' => '0',
                                      'Dist::Zilla::Plugin::CheckPrereqsIndexed' => '0',
                                      'Dist::Zilla::Plugin::ConfirmRelease' => '0',
                                      'Dist::Zilla::Plugin::ContributorsFromGit' => '0.005',
                                      'Dist::Zilla::Plugin::ExecDir' => '0',
                                      'Dist::Zilla::Plugin::GatherDir' => '0',
                                      'Dist::Zilla::Plugin::GenerateFile' => '0',
                                      'Dist::Zilla::Plugin::Git::Describe' => '0',
                                      'Dist::Zilla::Plugin::Git::Init' => '0',
                                      'Dist::Zilla::Plugin::Git::NextVersion' => '0',
                                      'Dist::Zilla::Plugin::GithubMeta' => '0.10',
                                      'Dist::Zilla::Plugin::InstallRelease' => '0.006',
                                      'Dist::Zilla::Plugin::License' => '0',
                                      'Dist::Zilla::Plugin::MakeMaker' => '0',
                                      'Dist::Zilla::Plugin::Manifest' => '0',
                                      'Dist::Zilla::Plugin::ManifestSkip' => '0',
                                      'Dist::Zilla::Plugin::MetaConfig' => '0',
                                      'Dist::Zilla::Plugin::MetaJSON' => '0',
                                      'Dist::Zilla::Plugin::MetaNoIndex' => '1.10113',
                                      'Dist::Zilla::Plugin::MetaProvides::Package' => '1.14000001',
                                      'Dist::Zilla::Plugin::MetaYAML' => '0',
                                      'Dist::Zilla::Plugin::MinimumPerl' => '1.003',
                                      'Dist::Zilla::Plugin::NextRelease' => '0',
                                      'Dist::Zilla::Plugin::OurPkgVersion' => '0.002',
                                      'Dist::Zilla::Plugin::PkgVersion' => '0',
                                      'Dist::Zilla::Plugin::PodWeaver' => '0',
                                      'Dist::Zilla::Plugin::Prepender' => '1.112280',
                                      'Dist::Zilla::Plugin::PruneCruft' => '0',
                                      'Dist::Zilla::Plugin::PruneFiles' => '0',
                                      'Dist::Zilla::Plugin::Readme' => '0',
                                      'Dist::Zilla::Plugin::ReadmeAnyFromPod' => '0.120120',
                                      'Dist::Zilla::Plugin::Repository' => '0.16',
                                      'Dist::Zilla::Plugin::Run' => '0.014',
                                      'Dist::Zilla::Plugin::Run::AfterMint' => '0',
                                      'Dist::Zilla::Plugin::ShareDir' => '0',
                                      'Dist::Zilla::Plugin::TemplateModule' => '0',
                                      'Dist::Zilla::Plugin::Test::ChangesHasContent' => '0.006',
                                      'Dist::Zilla::Plugin::Test::PodSpelling' => '0',
                                      'Dist::Zilla::Plugin::Test::ReportPrereqs' => '0.004',
                                      'Dist::Zilla::Plugin::TestRelease' => '0',
                                      'Dist::Zilla::Plugin::UploadToCPAN' => '0',
                                      'Dist::Zilla::PluginBundle::Git' => '2.004',
                                      'Dist::Zilla::PluginBundle::TestingMania' => '0.019',
                                      'Dist::Zilla::Role::MintingProfile::ShareDir' => '0',
                                      'Dist::Zilla::Role::PluginBundle::Config::Slicer' => '0',
                                      'Dist::Zilla::Role::PluginBundle::Easy' => '0',
                                      'Dist::Zilla::Role::PluginBundle::PluginRemover' => '0',
                                      'Dist::Zilla::Stash::PodWeaver' => '1.005',
                                      'Git::Wrapper' => '0',
                                      'List::Util' => '0',
                                      'Moose' => '0',
                                      'Moose::Util::TypeConstraints' => '1.01',
                                      'MooseX::AttributeShortcuts' => '0',
                                      'Pod::Elemental::Transformer::List' => '0',
                                      'Pod::Markdown' => '2.000',
                                      'Pod::Weaver' => '4',
                                      'Pod::Weaver::Config::Assembler' => '0',
                                      'Pod::Weaver::Plugin::SingleEncoding' => '0',
                                      'Pod::Weaver::Plugin::StopWords' => '1.005',
                                      'Pod::Weaver::Plugin::Transformer' => '0',
                                      'Pod::Weaver::Plugin::WikiDoc' => '0',
                                      'Pod::Weaver::PluginBundle::CorePrep' => '0',
                                      'Pod::Weaver::Section::Authors' => '0',
                                      'Pod::Weaver::Section::Collect' => '0',
                                      'Pod::Weaver::Section::Contributors' => '0',
                                      'Pod::Weaver::Section::Generic' => '0',
                                      'Pod::Weaver::Section::Leftovers' => '0',
                                      'Pod::Weaver::Section::Legal' => '0',
                                      'Pod::Weaver::Section::Name' => '0',
                                      'Pod::Weaver::Section::Region' => '0',
                                      'Pod::Weaver::Section::Support' => '1.005',
                                      'Pod::Weaver::Section::Version' => '0',
                                      'YAML::Tiny' => '0',
                                      'perl' => '5.006',
                                      'strict' => '0',
                                      'warnings' => '0'
                                    }
                    },
       'test' => {
                   'recommends' => {
                                     'CPAN::Meta' => '0',
                                     'CPAN::Meta::Requirements' => '2.120900'
                                   },
                   'requires' => {
                                   'Dist::Zilla::Role::Plugin' => '0',
                                   'Dist::Zilla::Role::Releaser' => '0',
                                   'ExtUtils::MakeMaker' => '0',
                                   'File::Spec' => '0',
                                   'File::Spec::Functions' => '0',
                                   'File::Temp' => '0',
                                   'IO::Handle' => '0',
                                   'IPC::Open3' => '0',
                                   'Path::Class' => '0',
                                   'Test::DZil' => '0',
                                   'Test::File::ShareDir' => '0',
                                   'Test::More' => '0.96',
                                   'lib' => '0',
                                   'perl' => '5.006',
                                   'version' => '0'
                                 }
                 }
     };
  $x;
 };

delete $static_prereqs->{develop} if not $ENV{AUTHOR_TESTING};
$include{$_} = 1 for map { keys %$_ } map { values %$_ } values %$static_prereqs;

# Merge requirements for major phases (if we can)
my $all_requires;
if ( $DO_VERIFY_PREREQS && $HAS_CPAN_META_REQ ) {
    $all_requires = $cpan_meta_req->new;
    _merge_requires($all_requires, $static_prereqs);
}


# Add dynamic prereqs to the included modules list (if we can)
my ($source) = grep { -f } 'MYMETA.json', 'MYMETA.yml';
if ( $source && $HAS_CPAN_META ) {
  if ( my $meta = eval { CPAN::Meta->load_file($source) } ) {
    my $dynamic_prereqs = $meta->prereqs;
    delete $dynamic_prereqs->{develop} if not $ENV{AUTHOR_TESTING};
    $include{$_} = 1 for map { keys %$_ } map { values %$_ } values %$dynamic_prereqs;

    if ( $DO_VERIFY_PREREQS && $HAS_CPAN_META_REQ ) {
        _merge_requires($all_requires, $dynamic_prereqs);
    }
  }
}
else {
  $source = 'static metadata';
}

my @modules = sort grep { ! $exclude{$_} } keys %include;
my @reports = [qw/Version Module/];
my @dep_errors;
my $req_hash = defined($all_requires) ? $all_requires->as_string_hash : {};

for my $mod ( @modules ) {
  next if $mod eq 'perl';
  my $file = $mod;
  $file =~ s{::}{/}g;
  $file .= ".pm";
  my ($prefix) = grep { -e catfile($_, $file) } @INC;
  if ( $prefix ) {
    my $ver = MM->parse_version( catfile($prefix, $file) );
    $ver = "undef" unless defined $ver; # Newer MM should do this anyway
    push @reports, [$ver, $mod];

    if ( $DO_VERIFY_PREREQS && $all_requires ) {
      my $req = $req_hash->{$mod};
      if ( defined $req && length $req ) {
        if ( ! defined eval { version->parse($ver) } ) {
          push @dep_errors, "$mod version '$ver' cannot be parsed (version '$req' required)";
        }
        elsif ( ! $all_requires->accepts_module( $mod => $ver ) ) {
          push @dep_errors, "$mod version '$ver' is not in required range '$req'";
        }
      }
    }

  }
  else {
    push @reports, ["missing", $mod];

    if ( $DO_VERIFY_PREREQS && $all_requires ) {
      my $req = $req_hash->{$mod};
      if ( defined $req && length $req ) {
        push @dep_errors, "$mod is not installed (version '$req' required)";
      }
    }
  }
}

if ( @reports ) {
  my $vl = max map { length $_->[0] } @reports;
  my $ml = max map { length $_->[1] } @reports;
  splice @reports, 1, 0, ["-" x $vl, "-" x $ml];
  diag "\nVersions for all modules listed in $source (including optional ones):\n",
    map {sprintf("  %*s %*s\n",$vl,$_->[0],-$ml,$_->[1])} @reports;
}

if ( @dep_errors ) {
  diag join("\n",
    "\n*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***\n",
    "The following REQUIRED prerequisites were not satisfied:\n",
    @dep_errors,
    "\n"
  );
}

pass;

# vim: ts=4 sts=4 sw=4 et:
