use utf8;

package SemanticWeb::Schema::RegisterAction;

# ABSTRACT: The act of registering to be a user of a service

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::InteractAction /;


use MooX::JSON_LD 'RegisterAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.1';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::RegisterAction - The act of registering to be a user of a service

=head1 VERSION

version v21.0.1

=head1 DESCRIPTION

The act of registering to be a user of a service, product or web page.

Related actions:

=over

=item *

L<SemanticWeb::Schema::JoinAction>: Unlike JoinAction, RegisterAction implies you are registering to be a user of a service, I<not> a group/team of people.

=item *

L<SemanticWeb::Schema::FollowAction>: Unlike FollowAction, RegisterAction doesn't imply that the agent is expecting to poll for updates from the object.

=item *

L<SemanticWeb::Schema::SubscribeAction>: Unlike SubscribeAction, RegisterAction doesn't imply that the agent is expecting updates from the object.

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::InteractAction>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
