use utf8;

package SemanticWeb::Schema::TouristAttraction;

# ABSTRACT: A tourist attraction

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::Place /;


use MooX::JSON_LD 'TouristAttraction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.0';


has available_language => (
    is        => 'rw',
    predicate => '_has_available_language',
    json_ld   => 'availableLanguage',
);



has tourist_type => (
    is        => 'rw',
    predicate => '_has_tourist_type',
    json_ld   => 'touristType',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::TouristAttraction - A tourist attraction

=head1 VERSION

version v21.0.0

=head1 DESCRIPTION

A tourist attraction.  In principle any Thing can be a L<SemanticWeb::Schema::TouristAttraction>, from a L<SemanticWeb::Schema::Mountain> and L<SemanticWeb::Schema::LandmarksOrHistoricalBuildings> to a L<SemanticWeb::Schema::LocalBusiness>.  This Type can be used on its own to describe a general L<SemanticWeb::Schema::TouristAttraction>, or be used as an [[additionalType]] to add tourist attraction properties to any other type.  (See examples below)

=head1 ATTRIBUTES

=head2 C<available_language>

C<availableLanguage>

A language someone may use with or at the item, service or place. Please use one of the language codes from the L<IETF BCP 47 standard|http://tools.ietf.org/html/bcp47>. See also [[inLanguage]].

A available_language should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Language']>

=item C<Str>

=back

=head2 C<_has_available_language>

A predicate for the L</available_language> attribute.

=head2 C<tourist_type>

C<touristType>

Attraction suitable for type(s) of tourist. E.g. children, visitors from a
particular country, etc. 

A tourist_type should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Audience']>

=item C<Str>

=back

=head2 C<_has_tourist_type>

A predicate for the L</tourist_type> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Place>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
