use utf8;

package SemanticWeb::Schema::ProfessionalService;

# ABSTRACT: Original definition: "provider of professional services

use Moo;

extends qw/ SemanticWeb::Schema::LocalBusiness /;


use MooX::JSON_LD 'ProfessionalService';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v13.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::ProfessionalService - Original definition: "provider of professional services

=head1 VERSION

version v13.0.0

=head1 DESCRIPTION

Original definition: "provider of professional services."

The general L<SemanticWeb::Schema::ProfessionalService> type for local businesses was deprecated due to confusion with L<SemanticWeb::Schema::Service>. For reference, the types that it included were: L<SemanticWeb::Schema::Dentist>,
        L<SemanticWeb::Schema::AccountingService>, L<SemanticWeb::Schema::Attorney>, L<SemanticWeb::Schema::Notary>, as well as types for several kinds of L<SemanticWeb::Schema::HomeAndConstructionBusiness>: L<SemanticWeb::Schema::Electrician>, L<SemanticWeb::Schema::GeneralContractor>,
        L<SemanticWeb::Schema::HousePainter>, L<SemanticWeb::Schema::Locksmith>, L<SemanticWeb::Schema::Plumber>, L<SemanticWeb::Schema::RoofingContractor>. L<SemanticWeb::Schema::LegalService> was introduced as a more inclusive supertype of L<SemanticWeb::Schema::Attorney>.

=head1 SEE ALSO

L<SemanticWeb::Schema::LocalBusiness>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
