use utf8;

package SemanticWeb::Schema::CreditCard;

# ABSTRACT: A card payment method of a particular brand or name

use Moo;

extends qw/ SemanticWeb::Schema::LoanOrCredit SemanticWeb::Schema::PaymentCard /;


use MooX::JSON_LD 'CreditCard';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v12.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::CreditCard - A card payment method of a particular brand or name

=head1 VERSION

version v12.0.0

=head1 DESCRIPTION

A card payment method of a particular brand or name.  Used to mark up a particular payment method and/or the financial product/service that supplies the card account.

Commonly used values:

=over

=item *

http://purl.org/goodrelations/v1#AmericanExpress

=item *

http://purl.org/goodrelations/v1#DinersClub

=item *

http://purl.org/goodrelations/v1#Discover

=item *

http://purl.org/goodrelations/v1#JCB

=item *

http://purl.org/goodrelations/v1#MasterCard

=item *

http://purl.org/goodrelations/v1#VISA

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::PaymentCard>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
