package SemanticWeb::Schema::Language;

# ABSTRACT: Natural languages such as Spanish

use Moo;

extends qw/ SemanticWeb::Schema::Intangible /;


use MooX::JSON_LD 'Language';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v0.0.1';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::Language - Natural languages such as Spanish

=head1 VERSION

version v0.0.1

=head1 DESCRIPTION

=for html Natural languages such as Spanish, Tamil, Hindi, English, etc. Formal
language code tags expressed in <a
href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> can be
used via the <a class="localLink"
href="http://schema.org/alternateName">alternateName</a> property. The
Language type previously also covered programming languages such as Scheme
and Lisp, which are now best represented using <a class="localLink"
href="http://schema.org/ComputerLanguage">ComputerLanguage</a>.

=head1 SEE ALSO

L<SemanticWeb::Schema::Intangible>

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
