# podlators 4.10

Copyright 1999-2010, 2012-2017 Russ Allbery <rra@cpan.org>.  This software
is distributed under the same terms as Perl itself.  Please see the
section [License](#license) below for more information.

## Blurb

podlators contains Pod::Man and Pod::Text modules which convert POD input
to *roff source output, suitable for man pages, or plain text.  It also
includes several subclasses of Pod::Text for formatted output to terminals
with various capabilities.  It is the source package for the Pod::Man and
Pod::Text modules included with Perl.

## Description

POD is the Plain Old Documentation format, the documentation language used
for all of Perl's documentation.  I learned it to document Perl modules,
started using it for Perl scripts as well, and discovered it was the most
convenient way I've found to write program documentation.  It's extremely
simple, well-designed for writing Unix manual pages (and I'm a
traditionalist who thinks that any program should have a regular manual
page), and easily readable in the raw format by humans.

The translators into text and nroff (for manual pages) included in the
Perl distribution had various bugs, however, and used their own ad hoc
parsers, so when I started running into those bugs and when a new generic
parser (Pod::Parser) was written, I decided to rewrite the two translators
that I use the most and fix the bugs that were bothering me.  This package
is the result.

podlators contains two main modules, Pod::Man and Pod::Text.  The former
converts POD into nroff/troff source and the latter into plain text (with
various options controlling some of the formatting).  There are also
several subclasses of Pod::Text for generating slightly formatted text
using color or other terminal control escapes, and a general utility
module, Pod::ParseLink, for parsing the POD `L<>` formatting sequences.
Also included in this package are the `pod2text` and `pod2man` driver
scripts.

Both Pod::Text and Pod::Man provide a variety of options for fine-tuning
their output.  Pod::Man also tries to massage input text where appropriate
to produce better output when run through nroff or troff, such as
distinguishing between different types of hyphens and using slightly
smaller case for acronyms.

As of Perl 5.6.0, my implementation was included in Perl core, and each
release of Perl will have the at-the-time most current version of
podlators included.  You therefore only need to install this package
yourself if you have an old version of Perl or need a newer version than
came with Perl (to get some bug fixes, for example).

## Requirements

Perl 5.6.0 or later and Module::Build are required to build this module.
Both Pod::Man and Pod::Text are built on Pod::Simple, which handles the
basic POD parsing and character set conversion.  Pod::Simple 3.06 or later
is required (and Pod::Simple 3.07 is recommended).  It is available from
CPAN and part of Perl core as of 5.10.0.  Encode is also required
(included in Perl core since 5.8.0).

The troff/nroff generated by Pod::Man should be compatible with any troff
or nroff implementation with the `-man` macro set.  It is primarily tested
by me under GNU groff, but Perl users send bug reports for a wide variety
of implementations and Pod::Man is used to generate all of Perl's own
manual pages, so most of the bugs have been weeded out.

The test suite requires Test::More (part of Perl since 5.6.2).  The
following additional Perl modules will be used by the test suite if
present:

* Test::MinimumVersion
* Test::Pod
* Test::Spelling
* Test::Strict
* Test::Synopsis

All are available on CPAN.  Those tests will be skipped if the modules are
not available.

To enable tests that don't detect functionality problems but are used to
sanity-check the release, set the environment variable `RELEASE_TESTING`
to a true value.  To enable tests that may be sensitive to the local
environment or that produce a lot of false positives without uncovering
many problems, set the environment variable `AUTHOR_TESTING` to a true
value.

## Building and Installation

podlators uses ExtUtils::MakeMaker and can be installed using the same
process as any other ExtUtils::MakeMaker module:

```
    perl Makefile.PL
    make
    make test
    make install
```

You'll probably need to do the last as root unless you're installing into
a local Perl module tree in your home directory.

## Support

The [podlators web page](https://www.eyrie.org/~eagle/software/podlators/)
will always have the current version of this package, the current
documentation, and pointers to any additional resources.

For bug tracking, use the [CPAN bug
tracker](https://rt.cpan.org/Dist/Display.html?Name=podlators).  However,
please be aware that I tend to be extremely busy and work projects often
take priority.  I'll save your report and get to it as soon as I can, but
it may take me a couple of months.

## Source Repository

podlators is maintained using Git.  You can access the current source on
[GitHub](https://github.com/rra/podlators) or by cloning the repository
at:

https://git.eyrie.org/git/perl/podlators.git

or [view the repository on the
web](https://git.eyrie.org/?p=perl/podlators.git).

The eyrie.org repository is the canonical one, maintained by the author,
but using GitHub is probably more convenient for most purposes.  Pull
requests are gratefully reviewed and normally accepted.  It's probably
better to use the CPAN bug tracker than GitHub issues, though, to keep all
Perl module issues in the same place.

## License

The podlators package as a whole is covered by the following copyright
statement and license:

> Copyright 1999-2010, 2012-2017
>     Russ Allbery <rra@cpan.org>
>
> This program is free software; you may redistribute it and/or modify it
> under the same terms as Perl itself.  This means that you may choose
> between the two licenses that Perl is released under: the GNU GPL and the
> Artistic License.  Please see your Perl distribution for the details and
> copies of the licenses.

Some files in this distribution are individually released under different
licenses, all of which are compatible with the above general package
license but which may require preservation of additional notices.  All
required notices, and detailed information about the licensing of each
file, are recorded in the LICENSE file.

For any copyright range specified by files in this package as YYYY-ZZZZ,
the range specifies every single year in that closed interval.
