# NOTE: Derived from blib/lib/List/MoreUtil.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package List::MoreUtil;

#line 713 "blib/lib/List/MoreUtil.pm (autosplit into blib/lib/auto/List/MoreUtil/pairwise.al)"
#--->     @c = pairwise {code} @a, @b;
#
# Change History:
#     06/27/2002  EJR  First version
#     02/23/2003  EJR  Several improvements; thanks to Benjamin Goldberg
sub pairwise(&\@\@)
{
    my $op = shift;
    local (*A, *B) = @_;    # syms for caller's input arrays

    # Localise $a, $b
    my ($caller_a, $caller_b) = do
    {
        my $pkg = caller();
        no strict 'refs';
        \*{$pkg.'::a'}, \*{$pkg.'::b'};
    };

    my $limit = $#A > $#B? $#A : $#B;    # loop iteration limit

    local(*$caller_a, *$caller_b);
    map    # This map expression is also the return value.
    {
        # assign to $a, $b as refs to caller's array elements
        (*$caller_a, *$caller_b) = \($A[$_], $B[$_]);
        $op->();    # perform the transformation
    }  0 .. $limit;
}

1;
# end of List::MoreUtil::pairwise
