=head1 NAME

AdminFAQ - The Perl Bug Administrator FAQ

=head1 DESCRIPTION

Frequently Asked Questions related to Perl Bug Administration.

$Revision: 1.4 $
$Date: 2001/12/03 10:39:21 $

=head1 This FAQ

This FAQ is intended for use by the perlbug administrators.  The
latest version can be found at
http://bugs.perl.org/admin/perlbug.cgi?req=adminfaq.  If you have any
comments or patches to this document, please send them to the author
at the address below.

=head1 Who are the perl bugmongers?

The perl bugmongers are the Perl Bug Adminstrators.  Some of these people are
active Perl Porters, others are just interested in learning or helping out.  

=head1 What do the bugmongers do?

=over 2

=item * Clean up old bugs

=item * Organize/categorize and assign new bugs

=item * Discuss better ways for dealing with perl bugs

=back 

=head1 What is the lifecycle of a perl bug?

=over 2

=item 1. A Bug report is submitted with perlbug (to perlbug@perl.org|perlbug@perl.com|macperlbug@perl.org|perl-win32-porters@perl.org|module-bug@perl.org)

=item 2. A tracking number is automatically generated by the perlbugtron, and
the message is forwarded to p5p (or macperl-porters@macperl.org|perl-win32-porters@activestate.com)

=item 3. A discusion (hopefully) ensues on p5p regarding a solution for the
bug.  (During this time the bug should be categorized, and possibly assigned.)

=item 4. One or more solutions are proposed, and one is approved by
consensus and/or the pumpking.

=item 5. The bug is marked as closed.

=back

=head1 How do I close a bug?

This process varies depending on the age of the bug.  There are many bugs in
the bug database dating back several years.  Many of these bugs have already
been solved in recent version of perl.  These are old bugs.  

Everything else is a new bug.

(Another way to make this distinction is this:  Anything that requires the
attention of p5p is a new bug.)

=head2 How do I close a bug if I am not an administrator?

You can't do that directly.

You can send an email to admins@bugs.perl.org with your suggestions,
or to propose_close_<bugid>@bugs.perl.org

=head2 How do I close an _old_ bug?

=over 2

=item 1. Perform the necessary tests to prove it has been solved.

=item 2.  Make an entry in the bug database noting the reason you are
closing it.  This can be as simple as "fixed in perl 5.6.0 (tested on
Jul 17 2000)".

The easiest way to make this entry is to send a message to
close_<bugid>@bugs.perl.org, where the content of the message is the
log entry.

=back

=head2 How do I close a _new_ bug?

If there has been a thread on p5p culminating in a patch (or some other
final looking statement), mark the bug as closed.  You may wish to add
a comment along the lines of "resolved in <msgid>"

=head1 When do I delete a bug?

The short answer is B<NEVER>.

There may be times when a bug should not be in the database, for example,
spam that may have gotten through, or an exact duplicate of another
bug report.  (And in the duplicate case, it's probably better to link
the bug to the other copy, to make sure the threads keep properly.)

=head1 I don't want to bother p5p with a bug related email.  How do I get it in the database?

Send (or CC) the email to track@bugs.perl.org -- it needs to have a
subject line that perlbug can understand.  i.e. it must contain "[ID
<bugid>]".

=head1 What versions of perl should I check for bugs to have been fixed in?

This depends greatly on when the bug was created.  Generally, you should check
5.00503, 5.6.0, perl-current, and perl-5.6.x-current.  (Theoretically, once it
works in an earlier version, it will work in all future versions, but it can't
help to perform the regression test by hand.)

=head1 Web Interface: Those Checkboxes

Discussed in bugmongers Message-id: <397466D6.6F05E8B8@m.dasa.de>

The perlbugtron user interface has a lot of checkboxes.  When you
modify items, you need to check the box for that item.  Otherwise,
when you click update, nothing will happen and you will receive an
error. 

The page you get back after altering bugs will only have the bugs
checked on it.  So if you have a list of 25 bugs, and you edit 3 of
them, the page you receive will have only these 3 bugs in it, for you
to peruse/check.  If you edit all 25 of them at once, the same
applies, it just may not look vastly different to begin with.

=head1 Why is the note field displayed _outside_ of the textarea?

The note is displayed next to the text area, so you can add another
one IN the text area.  If there's more than one, you get links to all
the notes instead.

=head1 What is the _abandoned_ status for?

The Abandoned status means: "This bug is no longer a priority or
probably cannot be fixed.  We may come back to fix it after all the
other bugs have been resolved."

Things are very rarely abandoned without good reason.

As of this writing, pre 5.6 install bugs are being abandoned.  The
installation system changed a lot for 5.6, and many issues were
resolved.

=head1 How do I get more help?

To get more help on the email interface, send a message with the
subject '-h' to bugdb@perl.org.  For more detailed help, use '-H';

Or you can use
http://bugs.perl.org/perlbug.cgi?req=mailhelp

The definitive location for more help on the web interface is

http://bugs.perl.org/admin/perlbug.cgi?req=webhelp  if you are an
administrator

Which is 
http://bugs.perl.org/perlbug.cgi?req=webhelp for normal users


=head1 AUTHOR

Robert Spier <rspier at cpan.org>


